/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.core.connectionmanager.pool.mcp.CapacityRequest;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;

class CapacityFiller
implements Runnable {
    private static final CapacityFiller INSTANCE = new CapacityFiller();
    private final LinkedList<CapacityRequest> crs = new LinkedList();
    private final Thread fillerThread;
    private static final String THREAD_FILLER_NAME = "JCA CapacityFiller";
    private AtomicBoolean threadStarted = new AtomicBoolean(false);

    static void schedule(CapacityRequest cr) {
        INSTANCE.internalSchedule(cr);
    }

    CapacityFiller() {
        this.fillerThread = new Thread((Runnable)this, THREAD_FILLER_NAME);
        this.fillerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader myClassLoader = this.getClass().getClassLoader();
        SecurityActions.setThreadContextClassLoader(myClassLoader);
        while (true) {
            Object cr;
            boolean empty = false;
            while (!empty) {
                cr = null;
                LinkedList<CapacityRequest> linkedList = this.crs;
                synchronized (linkedList) {
                    empty = this.crs.isEmpty();
                    if (!empty) {
                        cr = this.crs.removeFirst();
                    }
                }
                if (empty) continue;
                ((CapacityRequest)cr).getManagedConnectionPool().increaseCapacity(((CapacityRequest)cr).getSubject(), ((CapacityRequest)cr).getConnectionRequestInfo());
            }
            try {
                cr = this.crs;
                synchronized (cr) {
                    while (this.crs.isEmpty()) {
                        this.crs.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSchedule(CapacityRequest cr) {
        if (this.threadStarted.compareAndSet(false, true)) {
            this.fillerThread.start();
        }
        LinkedList<CapacityRequest> linkedList = this.crs;
        synchronized (linkedList) {
            this.crs.addLast(cr);
            this.crs.notifyAll();
        }
    }
}

