/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.realm.UsernameTokenRealmCodec;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.model.secext.UsernameTokenType;
import org.apache.cxf.ws.security.sts.provider.model.wstrust14.ObjectFactory;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.CustomTokenPrincipal;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenValidator
implements TokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(UsernameTokenValidator.class);
    private Validator validator = new org.apache.ws.security.validate.UsernameTokenValidator();
    private UsernameTokenRealmCodec usernameTokenRealmCodec;

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setUsernameTokenRealmCodec(UsernameTokenRealmCodec usernameTokenRealmCodec) {
        this.usernameTokenRealmCodec = usernameTokenRealmCodec;
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        return validateTarget.getToken() instanceof UsernameTokenType;
    }

    @Override
    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating UsernameToken");
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        Crypto sigCrypto = stsProperties.getSignatureCrypto();
        CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
        RequestData requestData = new RequestData();
        requestData.setSigCrypto(sigCrypto);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        requestData.setCallbackHandler(callbackHandler);
        TokenValidatorResponse response = new TokenValidatorResponse();
        ReceivedToken validateTarget = tokenParameters.getToken();
        validateTarget.setState(ReceivedToken.STATE.INVALID);
        response.setToken(validateTarget);
        if (!validateTarget.isUsernameToken()) {
            return response;
        }
        UsernameTokenType usernameTokenType = (UsernameTokenType)validateTarget.getToken();
        Element usernameTokenElement = null;
        try {
            HashSet<Class> classes = new HashSet<Class>();
            classes.add(org.apache.cxf.ws.security.sts.provider.model.ObjectFactory.class);
            classes.add(ObjectFactory.class);
            JAXBContextCache.CachedContextAndSchemas cache = JAXBContextCache.getCachedContextAndSchemas(classes, null, null, null, (boolean)false);
            JAXBContext jaxbContext = cache.getContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            Document doc = DOMUtils.createDocument();
            Element rootElement = doc.createElement("root-element");
            JAXBElement tokenType = new JAXBElement(QNameConstants.USERNAME_TOKEN, UsernameTokenType.class, (Object)usernameTokenType);
            marshaller.marshal((Object)tokenType, (Node)rootElement);
            usernameTokenElement = (Element)rootElement.getFirstChild();
        }
        catch (JAXBException ex) {
            LOG.log(Level.WARNING, "", ex);
            return response;
        }
        try {
            boolean allowNamespaceQualifiedPasswordTypes = wssConfig.getAllowNamespaceQualifiedPasswordTypes();
            boolean bspCompliant = wssConfig.isWsiBSPCompliant();
            UsernameToken ut = new UsernameToken(usernameTokenElement, allowNamespaceQualifiedPasswordTypes, bspCompliant);
            response.setPrincipal((Principal)new CustomTokenPrincipal(ut.getName()));
            if (ut.getPassword() == null) {
                return response;
            }
            int hash = ut.hashCode();
            SecurityToken secToken = null;
            if (tokenParameters.getTokenStore() != null && (secToken = tokenParameters.getTokenStore().getToken(Integer.toString(hash))) != null && secToken.getTokenHash() != hash) {
                secToken = null;
            }
            if (secToken == null) {
                Credential credential = new Credential();
                credential.setUsernametoken(ut);
                this.validator.validate(credential, requestData);
            }
            Principal principal = this.createPrincipal(ut.getName(), ut.getPassword(), ut.getPasswordType(), ut.getNonce(), ut.getCreated());
            String tokenRealm = null;
            if (this.usernameTokenRealmCodec != null) {
                String cachedRealm;
                Properties props;
                tokenRealm = this.usernameTokenRealmCodec.getRealmFromToken(ut);
                if (secToken != null && (props = secToken.getProperties()) != null && !tokenRealm.equals(cachedRealm = props.getProperty("org.apache.cxf.sts.token.realm"))) {
                    return response;
                }
            }
            if (tokenParameters.getTokenStore() != null && secToken == null) {
                secToken = new SecurityToken(ut.getID());
                secToken.setToken(ut.getElement());
                int hashCode = ut.hashCode();
                String identifier = Integer.toString(hashCode);
                secToken.setTokenHash(hashCode);
                tokenParameters.getTokenStore().add(identifier, secToken);
            }
            response.setPrincipal(principal);
            response.setTokenRealm(tokenRealm);
            validateTarget.setState(ReceivedToken.STATE.VALID);
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        return response;
    }

    private Principal createPrincipal(String username, String passwordValue, String passwordType, String nonce, String createdTime) {
        boolean hashed = false;
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(passwordType)) {
            hashed = true;
        }
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(username, hashed);
        principal.setNonce(nonce);
        principal.setPassword(passwordValue);
        principal.setCreatedTime(createdTime);
        principal.setPasswordType(passwordType);
        return principal;
    }
}

