/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.concurrent.TimeUnit;
import org.infinispan.util.TimeService;

public class DefaultTimeService
implements TimeService {
    @Override
    public long wallClockTime() {
        return System.currentTimeMillis();
    }

    @Override
    public long time() {
        return System.nanoTime();
    }

    @Override
    public long timeDuration(long startTime, TimeUnit outputTimeUnit) {
        return this.timeDuration(startTime, this.time(), outputTimeUnit);
    }

    @Override
    public long timeDuration(long startTime, long endTime, TimeUnit outputTimeUnit) {
        if (startTime < 0L || endTime < 0L || startTime >= endTime) {
            return 0L;
        }
        return outputTimeUnit.convert(endTime - startTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean isTimeExpired(long endTime) {
        return this.time() >= endTime;
    }

    @Override
    public long remainingTime(long endTime, TimeUnit outputTimeUnit) {
        if (endTime <= 0L) {
            return 0L;
        }
        long now = this.time();
        return now > endTime ? 0L : outputTimeUnit.convert(endTime - now, TimeUnit.NANOSECONDS);
    }

    @Override
    public long expectedEndTime(long duration, TimeUnit inputTimeUnit) {
        if (duration <= 0L) {
            return this.time();
        }
        return this.time() + inputTimeUnit.toNanos(duration);
    }
}

