/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.CacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

public class GlobalComponentRegistryService
implements Service<GlobalComponentRegistry> {
    private final Value<CacheContainer> manager;
    private volatile GlobalComponentRegistry registry;

    public static ServiceName getServiceName(String container) {
        return EmbeddedCacheManagerService.getServiceName(container).append(new String[]{"global-component-registry"});
    }

    public GlobalComponentRegistryService(Value<CacheContainer> manager) {
        this.manager = manager;
    }

    public GlobalComponentRegistry getValue() {
        return this.registry;
    }

    public void start(StartContext context) {
        this.registry = ((CacheContainer)this.manager.getValue()).getGlobalComponentRegistry();
        this.registry.start();
    }

    public void stop(StopContext context) {
        EmbeddedCacheManager manager = (EmbeddedCacheManager)this.manager.getValue();
        for (String cacheName : manager.getCacheNames()) {
            if (!manager.isRunning(cacheName)) continue;
            return;
        }
        this.registry.stop();
        this.registry = null;
    }
}

