/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.JAXWSDeployment;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.webserviceref.WSRefRegistry;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;

public final class ASHelper {
    private ASHelper() {
    }

    public static List<EJBEndpoint> getJaxwsEjbs(DeploymentUnit unit) {
        JAXWSDeployment jaxwsDeployment = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        return jaxwsDeployment != null ? jaxwsDeployment.getEjbEndpoints() : Collections.emptyList();
    }

    public static List<POJOEndpoint> getJaxwsPojos(DeploymentUnit unit) {
        JAXWSDeployment jaxwsDeployment = (JAXWSDeployment)unit.getAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        return jaxwsDeployment != null ? jaxwsDeployment.getPojoEndpoints() : Collections.emptyList();
    }

    public static String getEndpointName(ServletMetaData servletMD) {
        String endpointName = servletMD.getName();
        return endpointName != null ? endpointName.trim() : null;
    }

    public static String getEndpointClassName(ServletMetaData servletMD) {
        String endpointClass = servletMD.getServletClass();
        return endpointClass != null ? endpointClass.trim() : null;
    }

    public static ServletMetaData getServletForName(JBossWebMetaData jbossWebMD, String servletName) {
        for (JBossServletMetaData servlet : jbossWebMD.getServlets()) {
            if (!servlet.getName().equals(servletName)) continue;
            return servlet;
        }
        return null;
    }

    public static <A> A getRequiredAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        Object value = unit.getAttachment(key);
        if (value == null) {
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        return (A)unit.getAttachment(key);
    }

    public static boolean isJaxwsService(ClassInfo current, CompositeIndex index) {
        ClassInfo tmp = current;
        while (tmp != null) {
            DotName superName = tmp.superName();
            if (DotNames.JAXWS_SERVICE_CLASS.equals((Object)superName)) {
                return true;
            }
            tmp = index.getClassByName(superName);
        }
        return false;
    }

    public static boolean isJaxwsService(ClassInfo current, Index index) {
        ClassInfo tmp = current;
        while (tmp != null) {
            DotName superName = tmp.superName();
            if (DotNames.JAXWS_SERVICE_CLASS.equals((Object)superName)) {
                return true;
            }
            tmp = index.getClassByName(superName);
        }
        return false;
    }

    public static boolean hasClassesFromPackage(Index index, String pck) {
        for (ClassInfo ci : index.getKnownClasses()) {
            if (!ci.name().toString().startsWith(pck)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJaxwsEndpoint(ClassInfo clazz, CompositeIndex index) {
        short flags = clazz.flags();
        if (Modifier.isInterface(flags)) {
            return false;
        }
        if (Modifier.isAbstract(flags)) {
            return false;
        }
        if (!Modifier.isPublic(flags)) {
            return false;
        }
        if (ASHelper.isJaxwsService(clazz, index)) {
            return false;
        }
        boolean hasWebServiceAnnotation = clazz.annotations().containsKey(DotNames.WEB_SERVICE_ANNOTATION);
        boolean hasWebServiceProviderAnnotation = clazz.annotations().containsKey(DotNames.WEB_SERVICE_PROVIDER_ANNOTATION);
        if (!hasWebServiceAnnotation && !hasWebServiceProviderAnnotation) {
            return false;
        }
        if (hasWebServiceAnnotation && hasWebServiceProviderAnnotation) {
            WSLogger.ROOT_LOGGER.mutuallyExclusiveAnnotations(clazz.name().toString());
            return false;
        }
        if (Modifier.isFinal(flags)) {
            WSLogger.ROOT_LOGGER.finalEndpointClassDetected(clazz.name().toString());
            return false;
        }
        return true;
    }

    public static JBossWebMetaData getJBossWebMetaData(DeploymentUnit unit) {
        WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData result = null;
        if (warMetaData != null) {
            result = warMetaData.getMergedJBossWebMetaData();
            if (result == null) {
                result = warMetaData.getJBossWebMetaData();
            }
        } else {
            result = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JBOSSWEB_METADATA_KEY);
        }
        return result;
    }

    public static List<AnnotationInstance> getAnnotations(DeploymentUnit unit, DotName annotation) {
        CompositeIndex compositeIndex = (CompositeIndex)ASHelper.getRequiredAttachment(unit, Attachments.COMPOSITE_ANNOTATION_INDEX);
        return compositeIndex.getAnnotations(annotation);
    }

    public static JAXWSDeployment getJaxwsDeployment(DeploymentUnit unit) {
        JAXWSDeployment wsDeployment = (JAXWSDeployment)unit.getAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY);
        if (wsDeployment == null) {
            wsDeployment = new JAXWSDeployment();
            unit.putAttachment(WSAttachmentKeys.JAXWS_ENDPOINTS_KEY, (Object)wsDeployment);
        }
        return wsDeployment;
    }

    public static String getContextRoot(Deployment dep, JBossWebMetaData jbossWebMD) {
        ModuleMetaData moduleMD;
        DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
        JBossAppMetaData jbossAppMD = unit.getParent() == null ? null : ASHelper.getOptionalAttachment(unit.getParent(), WSAttachmentKeys.JBOSS_APP_METADATA_KEY);
        String contextRoot = null;
        if (jbossAppMD != null && (moduleMD = (ModuleMetaData)jbossAppMD.getModules().get(dep.getSimpleName())) != null) {
            WebModuleMetaData webModuleMD = (WebModuleMetaData)moduleMD.getValue();
            contextRoot = webModuleMD.getContextRoot();
        }
        if (contextRoot == null) {
            contextRoot = jbossWebMD != null ? jbossWebMD.getContextRoot() : null;
        }
        return contextRoot;
    }

    public static <T> T getMSCService(ServiceName serviceName, Class<T> clazz) {
        ServiceController service = CurrentServiceContainer.getServiceContainer().getService(serviceName);
        return (T)(service != null ? service.getValue() : null);
    }

    public static <T> T getMSCService(ServiceName serviceName, Class<T> clazz, OperationContext context) {
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        return (T)(service != null ? service.getValue() : null);
    }

    public static WSRefRegistry getWSRefRegistry(DeploymentUnit unit) {
        WSRefRegistry refRegistry = (WSRefRegistry)unit.getAttachment(WSAttachmentKeys.WS_REFREGISTRY);
        if (refRegistry == null) {
            refRegistry = WSRefRegistry.newInstance();
            unit.putAttachment(WSAttachmentKeys.WS_REFREGISTRY, (Object)refRegistry);
        }
        return refRegistry;
    }
}

