/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import java.io.File;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.metadata.PatchElementProvider;
import org.jboss.as.patching.validation.AbstractArtifact;
import org.jboss.as.patching.validation.Artifact;
import org.jboss.as.patching.validation.Context;
import org.jboss.as.patching.validation.PatchElementArtifact;

public class PatchElementProviderArtifact
extends AbstractArtifact<PatchElementArtifact.State, State> {
    private static final PatchElementProviderArtifact INSTANCE = new PatchElementProviderArtifact();

    public static PatchElementProviderArtifact getInstance() {
        return INSTANCE;
    }

    @Override
    protected State getInitialState(PatchElementArtifact.State parent, Context ctx) {
        State state = parent.getLayer();
        if (state != null) {
            return state;
        }
        PatchElementProvider metadata = parent.getMetadata().getProvider();
        Layer layer = ctx.getInstallationManager().getLayer(metadata.getName());
        if (layer == null) {
            ctx.getErrorHandler().error("Layer not found: " + metadata.getName());
            return null;
        }
        state = new State(layer, parent.getMetadata().getId());
        parent.setLayer(state);
        return state;
    }

    public static class State
    implements Artifact.State {
        private final PatchableTarget layer;
        private final String patchId;

        State(Layer layer, String patchId) {
            if (layer == null) {
                throw new IllegalArgumentException("layer is null");
            }
            if (patchId == null) {
                throw new IllegalArgumentException("patch element id is null");
            }
            this.layer = layer;
            this.patchId = patchId;
        }

        @Override
        public void validate(Context ctx) {
        }

        public File getBundlesDir() {
            File dir = this.layer.getDirectoryStructure().getBundlesPatchDirectory(this.patchId);
            return dir == null ? null : (dir.exists() ? dir : null);
        }

        public File getModulesDir() {
            File dir = this.layer.getDirectoryStructure().getModulePatchDirectory(this.patchId);
            return dir == null ? null : (dir.exists() ? dir : null);
        }
    }
}

