/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.interceptor.InvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptorException;
import org.jboss.weld.interceptor.spi.context.InterceptionChain;

public class InterceptorInvocationContext
implements InvocationContext {
    private final Map<String, Object> contextData;
    private final Method method;
    private Object[] parameters;
    private final Object target;
    private final InterceptionChain interceptionChain;
    private final Object timer;
    private final Constructor<?> constructor;
    private static final Map<Class<?>, Set<Class<?>>> WIDENING_TABLE;
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASSES;
    private static final Map<Class<?>, Class<?>> REVERSE_WRAPPER_CLASSES;

    private static Set<Class<?>> setOf(Class<?> ... classes) {
        return new HashSet(Arrays.asList(classes));
    }

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object[] parameters) {
        this(interceptionChain, target, targetMethod, null, parameters, null);
    }

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method targetMethod, Object timer) {
        this(interceptionChain, target, targetMethod, null, null, timer);
    }

    public InterceptorInvocationContext(InterceptionChain interceptionChain, Constructor<?> constructor, Object[] parameters, Map<String, Object> contextData) {
        this(interceptionChain, null, null, constructor, parameters, null, contextData);
    }

    private InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method method, Constructor<?> constructor, Object[] parameters, Object timer) {
        this(interceptionChain, target, method, constructor, parameters, timer, new HashMap<String, Object>());
    }

    private InterceptorInvocationContext(InterceptionChain interceptionChain, Object target, Method method, Constructor<?> constructor, Object[] parameters, Object timer, Map<String, Object> contextData) {
        this.interceptionChain = interceptionChain;
        this.target = target;
        this.method = method;
        this.constructor = constructor;
        this.parameters = parameters;
        this.timer = timer;
        this.contextData = contextData;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        if (this.method != null || this.constructor != null) {
            return this.parameters;
        }
        throw new IllegalStateException("Illegal invocation to getParameters() during lifecycle invocation");
    }

    public Object getTarget() {
        return this.target;
    }

    public Object proceed() throws Exception {
        try {
            return this.interceptionChain.invokeNextInterceptor(this);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InterceptorException(t);
        }
    }

    private static boolean isWideningPrimitive(Class<?> argumentClass, Class<?> targetClass) {
        return WIDENING_TABLE.containsKey(argumentClass) && WIDENING_TABLE.get(argumentClass).contains(targetClass);
    }

    private static Class<?> getWrapperClass(Class<?> primitiveClass) {
        if (!WRAPPER_CLASSES.containsKey(primitiveClass)) {
            return primitiveClass;
        }
        return WRAPPER_CLASSES.get(primitiveClass);
    }

    private static Class<?> getPrimitiveClass(Class<?> wrapperClass) {
        if (!REVERSE_WRAPPER_CLASSES.containsKey(wrapperClass)) {
            return wrapperClass;
        }
        return REVERSE_WRAPPER_CLASSES.get(wrapperClass);
    }

    public void setParameters(Object[] params) {
        if (this.method != null || this.constructor != null) {
            int newParametersCount = params == null ? 0 : params.length;
            Class<?>[] parameterTypes = null;
            parameterTypes = this.method != null ? this.method.getParameterTypes() : this.constructor.getParameterTypes();
            if (parameterTypes.length != newParametersCount) {
                throw new IllegalArgumentException("Wrong number of parameters: method has " + parameterTypes.length + ", attempting to set " + newParametersCount + (params != null ? "" : " (argument was null)"));
            }
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Class<?> methodParameterClass = parameterTypes[i];
                    if (params[i] != null) {
                        Class<?> newArgumentClass = params[i].getClass();
                        if (newArgumentClass.equals(methodParameterClass)) break;
                        if (newArgumentClass.isPrimitive()) {
                            if (methodParameterClass.isPrimitive()) {
                                if (InterceptorInvocationContext.isWideningPrimitive(newArgumentClass, methodParameterClass)) continue;
                                this.throwIAE(i, methodParameterClass, newArgumentClass);
                                continue;
                            }
                            Class<?> boxedArgumentClass = InterceptorInvocationContext.getWrapperClass(newArgumentClass);
                            if (methodParameterClass.isAssignableFrom(boxedArgumentClass)) continue;
                            this.throwIAE(i, methodParameterClass, newArgumentClass);
                            continue;
                        }
                        if (methodParameterClass.isPrimitive()) {
                            Class<?> unboxedClass = InterceptorInvocationContext.getPrimitiveClass(newArgumentClass);
                            if (unboxedClass.equals(methodParameterClass) || InterceptorInvocationContext.isWideningPrimitive(unboxedClass, methodParameterClass)) continue;
                            this.throwIAE(i, methodParameterClass, newArgumentClass);
                            continue;
                        }
                        if (methodParameterClass.isAssignableFrom(newArgumentClass)) continue;
                        this.throwIAE(i, methodParameterClass, newArgumentClass);
                        continue;
                    }
                    if (!parameterTypes[i].isPrimitive()) continue;
                    throw new IllegalArgumentException("Trying to set a null value on a " + parameterTypes[i].getName());
                }
                this.parameters = params;
            }
        } else {
            throw new IllegalStateException("Illegal invocation to setParameters() during lifecycle invocation");
        }
    }

    private void throwIAE(int i, Class<?> methodParameterClass, Class<? extends Object> newArgumentClass) {
        throw new IllegalArgumentException("Incompatible parameter type on position: " + i + " :" + newArgumentClass + " (expected type was " + methodParameterClass.getName() + ")");
    }

    public Object getTimer() {
        return this.timer;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> wrapperClasses = new HashMap<Class<Comparable<Boolean>>, Class>();
        wrapperClasses.put(Boolean.TYPE, Boolean.class);
        wrapperClasses.put(Byte.TYPE, Byte.class);
        wrapperClasses.put(Character.TYPE, Character.class);
        wrapperClasses.put(Short.TYPE, Short.class);
        wrapperClasses.put(Integer.TYPE, Integer.class);
        wrapperClasses.put(Long.TYPE, Long.class);
        wrapperClasses.put(Float.TYPE, Float.class);
        wrapperClasses.put(Double.TYPE, Double.class);
        WRAPPER_CLASSES = Collections.unmodifiableMap(wrapperClasses);
        HashMap reverseWrapperClasses = new HashMap();
        for (Map.Entry classEntry : wrapperClasses.entrySet()) {
            reverseWrapperClasses.put(classEntry.getValue(), classEntry.getKey());
        }
        REVERSE_WRAPPER_CLASSES = Collections.unmodifiableMap(reverseWrapperClasses);
        HashMap wideningTable = new HashMap();
        wideningTable.put(Byte.TYPE, InterceptorInvocationContext.setOf(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Short.TYPE, InterceptorInvocationContext.setOf(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Character.TYPE, InterceptorInvocationContext.setOf(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Integer.TYPE, InterceptorInvocationContext.setOf(Long.TYPE, Float.TYPE, Double.TYPE));
        wideningTable.put(Long.TYPE, InterceptorInvocationContext.setOf(Float.TYPE, Double.TYPE));
        wideningTable.put(Float.TYPE, Collections.singleton(Double.TYPE));
        WIDENING_TABLE = Collections.unmodifiableMap(wideningTable);
    }
}

