/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.SimpleInterceptorInvocation;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public abstract class AbstractInterceptorMetadata<T>
implements InterceptorMetadata<T> {
    private final Map<InterceptionType, List<MethodMetadata>> interceptorMethodMap;
    private final ClassMetadata<?> classMetadata;

    public AbstractInterceptorMetadata(ClassMetadata<?> classMetadata, Map<InterceptionType, List<MethodMetadata>> interceptorMethodMap) {
        this.classMetadata = classMetadata;
        this.interceptorMethodMap = interceptorMethodMap;
    }

    @Override
    public ClassMetadata<?> getInterceptorClass() {
        return this.classMetadata;
    }

    public List<MethodMetadata> getInterceptorMethods(InterceptionType interceptionType) {
        if (this.interceptorMethodMap != null) {
            List<MethodMetadata> methods = this.interceptorMethodMap.get((Object)interceptionType);
            return methods == null ? Collections.emptyList() : methods;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEligible(InterceptionType interceptionType) {
        if (this.interceptorMethodMap == null) {
            return false;
        }
        List<MethodMetadata> interceptorMethods = this.interceptorMethodMap.get((Object)interceptionType);
        return interceptorMethods != null && !interceptorMethods.isEmpty();
    }

    @Override
    public InterceptorInvocation getInterceptorInvocation(Object interceptorInstance, InterceptionType interceptionType) {
        return new SimpleInterceptorInvocation(interceptorInstance, interceptionType, this.getInterceptorMethods(interceptionType), this.isTargetClassInterceptor());
    }

    protected abstract boolean isTargetClassInterceptor();
}

