/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.creation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.batch.operations.JobStartException;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.BatchArtifacts;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobParser;

public class ArchiveXmlLoader {
    public static final String ARCHIVE_JOB_XML_DIR = "META-INF/batch-jobs/";
    public static final String ARCHIVE_BATCH_XML = "META-INF/batch.xml";

    public static BatchArtifacts loadBatchXml(ClassLoader classLoader) throws JobStartException {
        BatchArtifacts batchArtifacts = null;
        InputStream is = classLoader.getResourceAsStream(ARCHIVE_BATCH_XML);
        if (is == null) {
            return null;
        }
        try {
            batchArtifacts = JobParser.parseBatchArtifacts(is);
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToParseBatchXml(e, ARCHIVE_BATCH_XML);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return batchArtifacts;
    }

    public static <T> T loadJobXml(String jobName, Class<T> rootType, ClassLoader classLoader) throws JobStartException {
        InputStream is;
        Job jobOrStep = null;
        try {
            is = ArchiveXmlLoader.getJobXml(jobName, classLoader);
        }
        catch (IOException e) {
            throw BatchMessages.MESSAGES.failToGetJobXml(e, jobName);
        }
        try {
            jobOrStep = JobParser.parseJob(is);
        }
        catch (Exception e) {
            throw BatchMessages.MESSAGES.failToParseJobXml(e, jobName);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return (T)jobOrStep;
    }

    private static InputStream getJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        String path;
        InputStream is;
        if (!jobXml.endsWith(".xml")) {
            jobXml = jobXml + ".xml";
        }
        if ((is = classLoader.getResourceAsStream(path = ARCHIVE_JOB_XML_DIR + jobXml)) != null) {
            return is;
        }
        File jobFile = null;
        String jobpath = ArchiveXmlLoader.getSystemProperty("javax.jobpath");
        if (jobpath != null && !jobpath.isEmpty()) {
            String p;
            String[] jobPathElements;
            String[] arr$ = jobPathElements = jobpath.split(":");
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (jobFile = new File(p = arr$[i$], jobXml)).exists() && jobFile.isFile()); ++i$) {
            }
        }
        if (!(jobFile != null || (jobFile = new File(ArchiveXmlLoader.getSystemProperty("user.dir"), jobXml)).exists() && jobFile.isFile())) {
            jobFile = new File(jobXml);
        }
        is = new BufferedInputStream(new FileInputStream(jobFile));
        return is;
    }

    private static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }
}

