/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessInfo;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class DomainServerLifecycleHandlers {
    public static final String RESTART_SERVERS_NAME = "restart-servers";
    public static final String START_SERVERS_NAME = "start-servers";
    public static final String STOP_SERVERS_NAME = "stop-servers";
    private static final int TIMEOUT = 10000;

    public static void initializeServerInventory(ServerInventory serverInventory) {
        StopServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        StartServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        RestartServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        ReloadServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
    }

    public static void registerDomainHandlers(ManagementResourceRegistration registration) {
        DomainServerLifecycleHandlers.registerHandlers(registration, false);
    }

    public static void registerServerGroupHandlers(ManagementResourceRegistration registration) {
        DomainServerLifecycleHandlers.registerHandlers(registration, true);
    }

    private static void registerHandlers(ManagementResourceRegistration registration, boolean serverGroup) {
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, STOP_SERVERS_NAME), (OperationStepHandler)StopServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, START_SERVERS_NAME), (OperationStepHandler)StartServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, RESTART_SERVERS_NAME), (OperationStepHandler)RestartServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, "reload-servers"), (OperationStepHandler)ReloadServersLifecycleHandler.INSTANCE);
    }

    private static OperationDefinition getOperationDefinition(boolean serverGroup, String operationName) {
        SimpleAttributeDefinition blocking = SimpleAttributeDefinitionBuilder.create((String)"blocking", (ModelType)ModelType.BOOLEAN, (boolean)true).build();
        return new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver(serverGroup ? "server-group" : "domain")).addParameter((AttributeDefinition)blocking).setRuntimeOnly().build();
    }

    private static class ReloadServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "reload-servers";
        static final ReloadServersLifecycleHandler INSTANCE = new ReloadServersLifecycleHandler();

        private ReloadServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = operation.get("blocking").asBoolean(false);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = ReloadServersLifecycleHandler.this.serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = ReloadServersLifecycleHandler.this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = ReloadServersLifecycleHandler.this.serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        ReloadServersLifecycleHandler.this.serverInventory.reloadServer(serverModelName, false);
                        waitForServers.add(serverModelName);
                    }
                    if (blocking) {
                        ReloadServersLifecycleHandler.this.serverInventory.awaitServersState(waitForServers, true);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            context.stepCompleted();
        }
    }

    private static class RestartServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "restart-servers";
        static final RestartServersLifecycleHandler INSTANCE = new RestartServersLifecycleHandler();

        private RestartServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = operation.get("blocking").asBoolean(false);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = RestartServersLifecycleHandler.this.serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = RestartServersLifecycleHandler.this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = RestartServersLifecycleHandler.this.serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        RestartServersLifecycleHandler.this.serverInventory.restartServer(serverModelName, 10000, model);
                        waitForServers.add(serverModelName);
                    }
                    if (blocking) {
                        RestartServersLifecycleHandler.this.serverInventory.awaitServersState(waitForServers, true);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            context.stepCompleted();
        }
    }

    private static class StartServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "start-servers";
        static final StartServersLifecycleHandler INSTANCE = new StartServersLifecycleHandler();

        private StartServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = operation.get("blocking").asBoolean(false);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String hostName = (String)model.get("host").keys().iterator().next();
                    ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
                    Set<String> serversInGroup = StartServersLifecycleHandler.this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    if (serverConfig.isDefined()) {
                        context.getServiceRegistry(true);
                        for (Property config : serverConfig.asPropertyList()) {
                            ServerStatus status = StartServersLifecycleHandler.this.serverInventory.determineServerStatus(config.getName());
                            if (status == ServerStatus.STARTING || status == ServerStatus.STARTED || group != null && !serversInGroup.contains(config.getName())) continue;
                            if (status != ServerStatus.STOPPED) {
                                StartServersLifecycleHandler.this.serverInventory.stopServer(config.getName(), 10000);
                            }
                            StartServersLifecycleHandler.this.serverInventory.startServer(config.getName(), model);
                            waitForServers.add(config.getName());
                        }
                        if (blocking) {
                            StartServersLifecycleHandler.this.serverInventory.awaitServersState(waitForServers, true);
                        }
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            context.stepCompleted();
        }
    }

    private static class StopServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "stop-servers";
        static final StopServersLifecycleHandler INSTANCE = new StopServersLifecycleHandler();

        private StopServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final String group = this.getServerGroupName(operation);
            final boolean blocking = operation.get("blocking").asBoolean(false);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    if (group != null) {
                        HashSet<String> waitForServers = new HashSet<String>();
                        ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
                        for (String server : StopServersLifecycleHandler.this.getServersForGroup(model, group)) {
                            StopServersLifecycleHandler.this.serverInventory.stopServer(server, 10000);
                            waitForServers.add(server);
                        }
                        if (blocking) {
                            StopServersLifecycleHandler.this.serverInventory.awaitServersState(waitForServers, false);
                        }
                    } else {
                        StopServersLifecycleHandler.this.serverInventory.stopServers(10000, blocking);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            context.stepCompleted();
        }
    }

    private static abstract class AbstractHackLifecycleHandler
    implements OperationStepHandler {
        volatile ServerInventory serverInventory;

        protected AbstractHackLifecycleHandler() {
        }

        void setServerInventory(ServerInventory serverInventory) {
            this.serverInventory = serverInventory;
        }

        String getServerGroupName(ModelNode operation) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            if (address.size() == 0) {
                return null;
            }
            return address.getLastElement().getValue();
        }

        Set<String> getServersForGroup(ModelNode model, String groupName) {
            if (groupName == null) {
                return Collections.emptySet();
            }
            String hostName = (String)model.get("host").keys().iterator().next();
            ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
            if (!serverConfig.isDefined()) {
                return Collections.emptySet();
            }
            HashSet<String> servers = new HashSet<String>();
            for (Property config : serverConfig.asPropertyList()) {
                if (!groupName.equals(config.getValue().get("group").asString())) continue;
                servers.add(config.getName());
            }
            return servers;
        }
    }
}

