/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.MetadataTargetImpl;
import com.sun.faces.facelets.tag.jsf.ActionSourceRule;
import com.sun.faces.facelets.tag.jsf.ComponentTagHandlerDelegateImpl;
import com.sun.faces.facelets.tag.jsf.EditableValueHolderRule;
import com.sun.faces.facelets.tag.jsf.RenderPropertyRule;
import com.sun.faces.facelets.tag.jsf.ValueHolderRule;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponentTagHandler
extends ComponentHandler
implements ComponentTagHandlerDelegateImpl.CreateComponentDelegate {
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private Resource ccResource;
    private TagAttribute binding;
    private static final String ccInstanceVariableStandinKey = CompositeComponentTagHandler.class.getName() + "_";
    private static final String ATTACHED_OBJECT_HANDLERS_KEY = "javax.faces.view.AttachedObjectHandlers";

    public CompositeComponentTagHandler(Resource ccResource, ComponentConfig config) {
        super(config);
        this.ccResource = ccResource;
        this.binding = config.getTag().getAttributes().get("binding");
        ((ComponentTagHandlerDelegateImpl)this.getTagHandlerDelegate()).setCreateCompositeComponentDelegate(this);
    }

    @Override
    public UIComponent createComponent(FaceletContext ctx) {
        UIComponent cc;
        FacesContext context = ctx.getFacesContext();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, UIComponent.class);
            cc = (UIComponent)ve.getValue((ELContext)ctx);
            if (cc != null && !UIComponent.isCompositeComponent((UIComponent)cc)) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.compcomp.binding.eval.non.compcomp", this.binding.toString());
                }
                cc = null;
            }
            if (cc == null) {
                cc = context.getApplication().createComponent(context, this.ccResource);
                cc.setValueExpression("binding", ve);
                ve.setValue((ELContext)ctx, (Object)cc);
            }
        } else {
            cc = context.getApplication().createComponent(context, this.ccResource);
        }
        this.setCompositeComponent(context, cc);
        return cc;
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.setAttributes(ctx, c);
        super.applyNextHandler(ctx, c);
        this.applyCompositeComponent(ctx, c);
        if (ComponentHandler.isNew((UIComponent)c)) {
            FacesContext context = ctx.getFacesContext();
            String viewId = context.getViewRoot().getViewId();
            ViewDeclarationLanguageFactory factory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
            ViewDeclarationLanguage vdl = factory.getViewDeclarationLanguage(viewId);
            vdl.retargetAttachedObjects(context, c, CompositeComponentTagHandler.getAttachedObjectHandlers(c, false));
            vdl.retargetMethodExpressions(context, c);
            CompositeComponentTagHandler.getAttachedObjectHandlers(c).clear();
        }
    }

    @Override
    public void setCompositeComponent(FacesContext context, UIComponent cc) {
        String key;
        Map contextMap = context.getAttributes();
        if (!contextMap.containsKey(key = ccInstanceVariableStandinKey + this.tagId)) {
            contextMap.put(key, cc);
        }
    }

    @Override
    public UIComponent getCompositeComponent(FacesContext context) {
        Map contextMap = context.getAttributes();
        String key = ccInstanceVariableStandinKey + this.tagId;
        UIComponent result = (UIComponent)contextMap.get(key);
        return result;
    }

    public void setAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            if (ctx.getFacesContext().isProjectStage(ProjectStage.Development)) {
                Metadata meta = this.createMetaRuleset(instance.getClass()).finish();
                meta.applyMetadata(ctx, instance);
            } else {
                super.setAttributes(ctx, instance);
            }
        }
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        Util.notNull("type", type);
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent cc = this.getCompositeComponent(context);
        if (null == cc) {
            FaceletContext faceletContext = (FaceletContext)context.getAttributes().get("javax.faces.FACELET_CONTEXT");
            cc = this.createComponent(faceletContext);
            this.setCompositeComponent(context, cc);
        }
        CompositeComponentMetaRuleset m = new CompositeComponentMetaRuleset(this.getTag(), type, (BeanInfo)cc.getAttributes().get("javax.faces.component.BEANINFO_KEY"));
        m.ignore("binding").ignore("id");
        m.addRule(CompositeComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type)) {
            m.addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type)) {
            m.addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type)) {
                m.ignore("submittedValue");
                m.ignore("valid");
                m.addRule(EditableValueHolderRule.Instance);
            }
        }
        if (UISelectOne.class.isAssignableFrom(type) || UISelectMany.class.isAssignableFrom(type)) {
            m.addRule(RenderPropertyRule.Instance);
        }
        return m;
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component) {
        return CompositeComponentTagHandler.getAttachedObjectHandlers(component, true);
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component, boolean create) {
        Map attrs = component.getAttributes();
        ArrayList result = (ArrayList)attrs.get(ATTACHED_OBJECT_HANDLERS_KEY);
        if (result == null) {
            if (create) {
                result = new ArrayList();
                attrs.put(ATTACHED_OBJECT_HANDLERS_KEY, result);
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCompositeComponent(FaceletContext ctx, UIComponent c) throws IOException {
        UIPanel facetComponent;
        FacesContext facesContext = ctx.getFacesContext();
        VariableMapper orig = ctx.getVariableMapper();
        if (ComponentHandler.isNew((UIComponent)c)) {
            facetComponent = (UIPanel)facesContext.getApplication().createComponent("javax.faces.Panel");
            facetComponent.setRendererType("javax.faces.Group");
            c.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", facetComponent);
        } else {
            facetComponent = (UIPanel)c.getFacets().get("javax.faces.component.COMPOSITE_FACET_NAME");
        }
        assert (null != facetComponent);
        try {
            VariableMapperWrapper wrapper = new VariableMapperWrapper(orig){

                public ValueExpression resolveVariable(String variable) {
                    return super.resolveVariable(variable);
                }
            };
            ctx.setVariableMapper((VariableMapper)wrapper);
            ctx.includeFacelet((UIComponent)facetComponent, this.ccResource.getURL());
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    private static class CompositeComponentRule
    extends MetaRule {
        private static final CompositeComponentRule Instance = new CompositeComponentRule();

        private CompositeComponentRule() {
        }

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(UIComponent.class)) {
                Class<Object> type = meta.getPropertyType(name);
                if (type == null) {
                    type = Object.class;
                }
                if (!attribute.isLiteral()) {
                    return new CompositeExpressionMetadata(name, type, attribute);
                }
                return new LiteralAttributeMetadata(name, type, attribute);
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CompositeExpressionMetadata
        extends Metadata {
            private String name;
            private Class<?> type;
            private TagAttribute attr;

            public CompositeExpressionMetadata(String name, Class<?> type, TagAttribute attr) {
                this.name = name;
                this.type = type;
                this.attr = attr;
            }

            public void applyMetadata(FaceletContext ctx, Object instance) {
                ValueExpression ve = this.attr.getValueExpression(ctx, this.type);
                UIComponent cc = (UIComponent)instance;
                assert (UIComponent.isCompositeComponent((UIComponent)cc));
                Map attrs = cc.getAttributes();
                BeanInfo componentMetadata = (BeanInfo)attrs.get("javax.faces.component.BEANINFO_KEY");
                BeanDescriptor desc = componentMetadata.getBeanDescriptor();
                Collection attributesWithDeclaredDefaultValues = (Collection)desc.getValue("javax.faces.component.ATTR_NAMES_WITH_DEFAULT_VALUES");
                if (null != attributesWithDeclaredDefaultValues && attributesWithDeclaredDefaultValues.contains(this.name) && attrs.containsKey(this.name)) {
                    attrs.remove(this.name);
                }
                cc.setValueExpression(this.name, ve);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class LiteralAttributeMetadata
        extends Metadata {
            private String name;
            private Class<?> type;
            private TagAttribute attribute;

            public LiteralAttributeMetadata(String name, Class<?> type, TagAttribute attribute) {
                this.name = name;
                this.type = type;
                this.attribute = attribute;
            }

            public void applyMetadata(FaceletContext ctx, Object instance) {
                UIComponent c = (UIComponent)instance;
                Object value = this.attribute.getObject(ctx, this.type);
                if (value != null) {
                    c.getAttributes().put(this.name, value);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeComponentMetaRuleset
    extends MetaRulesetImpl {
        private BeanInfo compBeanInfo;
        private Class<?> type;

        public CompositeComponentMetaRuleset(Tag tag, Class<?> type, BeanInfo compBeanInfo) {
            super(tag, type);
            this.compBeanInfo = compBeanInfo;
            this.type = type;
        }

        @Override
        protected MetadataTarget getMetadataTarget() {
            try {
                return new CompositeMetadataTarget(this.type, this.compBeanInfo);
            }
            catch (IntrospectionException ie) {
                throw new FacesException((Throwable)ie);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CompositeMetadataTarget
        extends MetadataTargetImpl {
            private BeanInfo compBeanInfo;

            public CompositeMetadataTarget(Class<?> type, BeanInfo compBeanInfo) throws IntrospectionException {
                super(type);
                this.compBeanInfo = compBeanInfo;
            }

            @Override
            public Class getPropertyType(String name) {
                PropertyDescriptor compDescriptor = this.findDescriptor(name);
                if (compDescriptor != null) {
                    Object obj = compDescriptor.getValue("type");
                    if (null != obj && !(obj instanceof Class)) {
                        ValueExpression typeVE = (ValueExpression)obj;
                        String className = (String)typeVE.getValue(FacesContext.getCurrentInstance().getELContext());
                        if (className != null) {
                            className = this.prefix(className);
                            try {
                                return ReflectionUtil.forName(className);
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new FacesException((Throwable)cnfe);
                            }
                        }
                        return Object.class;
                    }
                    return (Class)obj;
                }
                return super.getPropertyType(name);
            }

            private PropertyDescriptor findDescriptor(String name) {
                for (PropertyDescriptor pd : this.compBeanInfo.getPropertyDescriptors()) {
                    if (!pd.getName().equals(name)) continue;
                    return pd;
                }
                return null;
            }

            private String prefix(String className) {
                if (className.indexOf(46) == -1 && Character.isUpperCase(className.charAt(0))) {
                    return "java.lang." + className;
                }
                return className;
            }
        }
    }
}

