/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.Util;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.ClientWindow;

public abstract class StateHelper {
    protected static final char[] STATE_FIELD_START = "<input type=\"hidden\" name=\"javax.faces.ViewState\" id=\"".toCharArray();
    protected static final char[] FIELD_MIDDLE = "\" value=\"".toCharArray();
    protected static final char[] FIELD_END = "\" />".toCharArray();
    protected static final char[] STATE_FIELD_AUTOCOMPLETE_END = "\" autocomplete=\"off\" />".toCharArray();
    protected SerializationProvider serialProvider;
    protected WebConfiguration webConfig;
    protected boolean compressViewState;
    protected char[] stateFieldStart;
    protected char[] fieldMiddle;
    protected char[] fieldEnd;
    private static final String TOKEN_NAME = "com.sun.faces.TOKEN";

    public StateHelper() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.serialProvider = SerializationProviderFactory.createInstance(ctx.getExternalContext());
        this.webConfig = WebConfiguration.getInstance(ctx.getExternalContext());
        this.compressViewState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
        this.stateFieldStart = STATE_FIELD_START;
        this.fieldMiddle = FIELD_MIDDLE;
        char[] cArray = this.fieldEnd = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState) ? STATE_FIELD_AUTOCOMPLETE_END : FIELD_END;
        if (this.serialProvider == null) {
            this.serialProvider = SerializationProviderFactory.createInstance(FacesContext.getCurrentInstance().getExternalContext());
        }
    }

    private String createCryptographicallyStrongToken() {
        String result = "" + System.currentTimeMillis();
        return result;
    }

    public String getCryptographicallyStrongTokenFromSession(FacesContext context) {
        String result = (String)context.getExternalContext().getSessionMap().get(TOKEN_NAME);
        if (null == result) {
            result = this.createCryptographicallyStrongToken();
            context.getExternalContext().getSessionMap().put(TOKEN_NAME, result);
        }
        return result;
    }

    public abstract void writeState(FacesContext var1, Object var2, StringBuilder var3) throws IOException;

    public abstract Object getState(FacesContext var1, String var2) throws IOException;

    public abstract boolean isStateless(FacesContext var1, String var2) throws IllegalStateException;

    protected static String getStateParamValue(FacesContext context) {
        String pValue = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState");
        if (pValue != null && pValue.length() == 0) {
            pValue = null;
        }
        return pValue;
    }

    protected void writeRenderKitIdField(FacesContext context, ResponseWriter writer) throws IOException {
        String result = context.getViewRoot().getRenderKitId();
        String defaultRkit = context.getApplication().getDefaultRenderKitId();
        if (null == defaultRkit) {
            defaultRkit = "HTML_BASIC";
        }
        if (result != null && !defaultRkit.equals(result)) {
            writer.startElement("input", (UIComponent)context.getViewRoot());
            writer.writeAttribute("type", (Object)"hidden", "type");
            writer.writeAttribute("name", (Object)"javax.faces.RenderKitId", "name");
            writer.writeAttribute("value", (Object)result, "value");
            writer.endElement("input");
        }
    }

    protected void writeClientWindowField(FacesContext context, ResponseWriter writer) throws IOException {
        ClientWindow window = context.getExternalContext().getClientWindow();
        if (null != window) {
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", (Object)"javax.faces.ClientWindow", null);
            writer.writeAttribute("id", (Object)Util.getClientWindowId(context), null);
            writer.writeAttribute("value", (Object)window.getId(), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                writer.writeAttribute("autocomplete", (Object)"off", null);
            }
            writer.endElement("input");
        }
    }
}

