/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.servlet.AbstractHTTPServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.ServletDelegate;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.transport.ServletHelper;

public class CXFServletExt
extends AbstractHTTPServlet
implements ServletDelegate {
    protected Endpoint endpoint;
    protected Bus bus;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.loadBus(sc);
    }

    protected void loadBus(ServletConfig servletConfig) throws ServletException {
        this.endpoint = ServletHelper.initEndpoint(servletConfig, this.getServletName());
        this.updateAvailableBusWithServletInfo(servletConfig);
    }

    private void updateAvailableBusWithServletInfo(ServletConfig servletConfig) {
        BusHolder holder = (BusHolder)this.endpoint.getService().getDeployment().getAttachment(BusHolder.class);
        this.bus = holder.getBus();
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(servletConfig.getServletContext()));
    }

    protected void invoke(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        ServletHelper.callRequestHandler(req, res, this.getServletContext(), this.bus, this.endpoint);
    }

    public void destroy() {
        ServletHelper.callPreDestroy(this.endpoint);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doHead(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doPut(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doDelete(request, response);
    }

    public void service(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.service(request, response);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    protected Bus getBus() {
        return this.bus;
    }
}

