/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.metadata;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.MTOM;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.common.deployment.SOAPAddressWSDLParser;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.stack.cxf.JBossWSInvoker;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;

public class MetadataBuilder {
    public DDBeans build(Deployment dep) {
        HashMap<QName, String> serviceNameAddressMap = new HashMap<QName, String>();
        HashMap<String, SOAPAddressWSDLParser> soapAddressWsdlParsers = new HashMap<String, SOAPAddressWSDLParser>();
        DDBeans dd = new DDBeans();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            DDEndpoint ddep = this.createDDEndpoint(ep.getTargetBeanClass(), (ArchiveDeployment)dep, ep);
            if (ep instanceof HttpEndpoint) {
                ddep.setInvoker(JBossWSInvoker.class.getName());
            }
            this.processWSDDContribution(ddep, (ArchiveDeployment)dep);
            this.processAddressRewrite(ddep, (ArchiveDeployment)dep, soapAddressWsdlParsers);
            Loggers.METADATA_LOGGER.addingServiceEndpointMetadata((Object)(Loggers.METADATA_LOGGER.isDebugEnabled() ? ddep.toStringExtended() : ddep.toString()));
            dd.addEndpoint(ddep);
            serviceNameAddressMap.put(ddep.getServiceName(), ddep.getAddress());
        }
        dep.setProperty("ServiceAddressMap", serviceNameAddressMap);
        return dd;
    }

    protected boolean isMtomEnabled(Class<?> beanClass) {
        boolean mtomEnabled;
        BindingType bindingType = beanClass.getAnnotation(BindingType.class);
        MTOM mtom = beanClass.getAnnotation(MTOM.class);
        boolean bl = mtomEnabled = mtom != null;
        if (!mtomEnabled && bindingType != null) {
            String binding = bindingType.value();
            mtomEnabled = binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        }
        return mtomEnabled;
    }

    private void processWSDDContribution(DDEndpoint endpoint, ArchiveDeployment dep) {
        WebservicesMetaData webservices = (WebservicesMetaData)dep.getAttachment(WebservicesMetaData.class);
        if (webservices != null) {
            for (WebserviceDescriptionMetaData wsDesc : webservices.getWebserviceDescriptions()) {
                for (PortComponentMetaData portComp : wsDesc.getPortComponents()) {
                    String wsdlFile;
                    UnifiedHandlerChainsMetaData chainWrapper;
                    String linkedId = portComp.getEjbLink() != null ? portComp.getEjbLink() : portComp.getServletLink();
                    String id = endpoint.getId();
                    if (!id.equals(linkedId)) continue;
                    if (portComp.getWsdlPort() != null) {
                        Loggers.METADATA_LOGGER.overridePortName(id, endpoint.getPortName(), portComp.getWsdlPort());
                        endpoint.setPortName(portComp.getWsdlPort());
                    }
                    if (portComp.getWsdlService() != null) {
                        Loggers.METADATA_LOGGER.overrideServiceName(id, endpoint.getServiceName(), portComp.getWsdlService());
                        endpoint.setServiceName(portComp.getWsdlService());
                    }
                    if ((chainWrapper = portComp.getHandlerChains()) != null) {
                        endpoint.setHandlers(this.convertEndpointHandlers(chainWrapper.getHandlerChains()));
                    }
                    if (portComp.isMtomEnabled()) {
                        Loggers.METADATA_LOGGER.enableMTOM(id);
                        endpoint.setMtomEnabled(true);
                        endpoint.setMtomThreshold(portComp.getMtomThreshold());
                    }
                    if (portComp.isAddressingEnabled()) {
                        Loggers.METADATA_LOGGER.enableAddressing(id);
                        endpoint.setAddressingEnabled(true);
                        endpoint.setAddressingRequired(portComp.isAddressingRequired());
                        endpoint.setAddressingResponses(portComp.getAddressingResponses());
                    }
                    if (portComp.isRespectBindingEnabled()) {
                        Loggers.METADATA_LOGGER.enableRespectBinding(id);
                        endpoint.setRespectBindingEnabled(true);
                    }
                    if ((wsdlFile = portComp.getWebserviceDescription().getWsdlFile()) == null) continue;
                    Loggers.METADATA_LOGGER.overridingWsdlFileLocation(id, wsdlFile);
                    endpoint.setWsdlLocation(wsdlFile);
                }
            }
        }
    }

    private List<String> convertEndpointHandlers(List<UnifiedHandlerChainMetaData> handlerChains) {
        LinkedList<String> handlers = new LinkedList<String>();
        if (handlerChains != null) {
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                if (handlerChain.getPortNamePattern() != null || handlerChain.getProtocolBindings() != null || handlerChain.getServiceNamePattern() != null) {
                    Loggers.METADATA_LOGGER.filtersNotSupported();
                }
                for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                    if (uhmd.getInitParams() != null && !uhmd.getInitParams().isEmpty()) {
                        Loggers.METADATA_LOGGER.initParamsSupported(uhmd.getHandlerName());
                    }
                    handlers.add(uhmd.getHandlerClass());
                }
            }
        }
        return handlers;
    }

    protected DDEndpoint createDDEndpoint(Class<?> sepClass, ArchiveDeployment dep, Endpoint ep) {
        String portName;
        String serviceNS;
        String serviceName;
        String name;
        WebService anWebService = sepClass.getAnnotation(WebService.class);
        WebServiceProvider anWebServiceProvider = sepClass.getAnnotation(WebServiceProvider.class);
        Class<?> seiClass = null;
        boolean missingServicePortAttr = false;
        String string = name = anWebService != null ? anWebService.name() : "";
        if (name.length() == 0) {
            name = JavaUtils.getJustClassName(sepClass);
        }
        String string2 = serviceName = anWebService != null ? anWebService.serviceName() : anWebServiceProvider.serviceName();
        if (serviceName.length() == 0) {
            missingServicePortAttr = true;
            serviceName = JavaUtils.getJustClassName(sepClass) + "Service";
        }
        String string3 = serviceNS = anWebService != null ? anWebService.targetNamespace() : anWebServiceProvider.targetNamespace();
        if (serviceNS.length() == 0) {
            serviceNS = MetadataBuilder.getTypeNamespace(JavaUtils.getPackageName(sepClass));
        }
        String string4 = portName = anWebService != null ? anWebService.portName() : anWebServiceProvider.portName();
        if (portName.length() == 0) {
            missingServicePortAttr = true;
            portName = name + "Port";
        }
        if (anWebService != null && anWebService.endpointInterface().length() > 0) {
            String seiName = anWebService.endpointInterface();
            ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
            if (null == runtimeClassLoader) {
                throw Messages.MESSAGES.runtimeLoaderCannotBeNull((Deployment)dep);
            }
            try {
                seiClass = runtimeClassLoader.loadClass(seiName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
            WebService seiAnnotation = seiClass.getAnnotation(WebService.class);
            if (seiAnnotation == null) {
                throw Messages.MESSAGES.webserviceAnnotationNotFound(seiName);
            }
            if (seiAnnotation.portName().length() > 0 || seiAnnotation.serviceName().length() > 0 || seiAnnotation.endpointInterface().length() > 0) {
                throw Messages.MESSAGES.webserviceAnnotationSEIAttributes(seiName);
            }
        }
        String annWsdlLocation = anWebService != null ? anWebService.wsdlLocation() : anWebServiceProvider.wsdlLocation();
        DDEndpoint result = new DDEndpoint();
        result.setId(ep.getShortName());
        result.setAddress(ep.getAddress());
        result.setImplementor(ep.getTargetBeanName());
        result.setMtomEnabled(this.isMtomEnabled(ep.getTargetBeanClass()));
        result.setEpClass(seiClass != null ? seiClass : sepClass);
        result.setPortName(new QName(serviceNS, portName));
        result.setServiceName(new QName(serviceNS, serviceName));
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String k : ep.getProperties()) {
            props.put(k, ep.getProperty(k));
        }
        result.setProperties(props);
        if (!missingServicePortAttr && annWsdlLocation.length() > 0) {
            result.setAnnotationWsdlLocation(annWsdlLocation);
        }
        return result;
    }

    protected void processAddressRewrite(DDEndpoint ddep, ArchiveDeployment dep, Map<String, SOAPAddressWSDLParser> soapAddressWsdlParsers) {
        String wsdlLocation = ddep.getWsdlLocation();
        if (wsdlLocation == null) {
            wsdlLocation = ddep.getAnnotationWsdlLocation();
        }
        ServerConfig sc = AbstractServerConfig.getServerIntegrationServerConfig();
        if (wsdlLocation != null) {
            URL wsdlUrl = dep.getResourceResolver().resolveFailSafe(wsdlLocation);
            if (wsdlUrl != null) {
                SOAPAddressWSDLParser parser = this.getCurrentSOAPAddressWSDLParser(wsdlUrl, soapAddressWsdlParsers);
                String wsdlAddress = parser.filterSoapAddress(ddep.getServiceName(), ddep.getPortName(), "http://schemas.xmlsoap.org/soap/http");
                String rewrittenWsdlAddress = SoapAddressRewriteHelper.getRewrittenPublishedEndpointUrl(wsdlAddress, ddep.getAddress(), sc);
                if (!SoapAddressRewriteHelper.isAutoRewriteOn(sc)) {
                    ddep.setPublishedEndpointUrl(rewrittenWsdlAddress);
                }
            } else {
                Loggers.METADATA_LOGGER.abortSoapAddressRewrite(wsdlLocation, null);
            }
        } else if (!SoapAddressRewriteHelper.isAutoRewriteOn(sc)) {
            ddep.setPublishedEndpointUrl(ddep.getAddress());
        }
    }

    private SOAPAddressWSDLParser getCurrentSOAPAddressWSDLParser(URL wsdlUrl, Map<String, SOAPAddressWSDLParser> soapAddressWsdlParsers) {
        String key = wsdlUrl.toString();
        SOAPAddressWSDLParser parser = soapAddressWsdlParsers.get(key);
        if (parser != null) {
            return parser;
        }
        parser = new SOAPAddressWSDLParser(wsdlUrl);
        soapAddressWsdlParsers.put(key, parser);
        return parser;
    }

    private static String getTypeNamespace(String packageName) {
        String next;
        StringBuilder sb = new StringBuilder("http://");
        StringTokenizer st = new StringTokenizer(packageName, ".");
        Stack<String> stk = new Stack<String>();
        while (st != null && st.hasMoreTokens()) {
            stk.push(st.nextToken());
        }
        while (!stk.isEmpty() && (next = (String)stk.pop()) != null) {
            if (!sb.toString().equals("http://")) {
                sb.append('.');
            }
            sb.append(next);
        }
        sb.append('/');
        return sb.toString();
    }
}

