/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.metadata.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.parsers.saml.metadata.SAMLEntityDescriptorParser;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.IMetadataConfigurationStore;
import org.picketlink.identity.federation.core.saml.v2.metadata.store.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLMetadataWriter;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;

public class FileBasedMetadataConfigurationStore
implements IMetadataConfigurationStore {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private String userHome = null;
    private String baseDirectory = null;

    public FileBasedMetadataConfigurationStore() {
        this.bootstrap();
    }

    @Override
    public void bootstrap() {
        this.userHome = SecurityActions.getSystemProperty("user.home");
        if (this.userHome == null) {
            throw logger.systemPropertyMissingError("user.home");
        }
        StringBuilder builder = new StringBuilder(this.userHome);
        builder.append("/picketlink-store");
        this.baseDirectory = builder.toString();
        File plStore = new File(this.baseDirectory);
        if (!plStore.exists()) {
            logger.trace(plStore.getPath() + " does not exist. Hence creating.");
            plStore.mkdir();
        }
    }

    @Override
    public Set<String> getIdentityProviderID() {
        HashSet<String> identityProviders = new HashSet<String>();
        Properties idp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/identityproviders.properties");
        File identityProviderFile = new File(builder.toString());
        if (identityProviderFile.exists()) {
            try {
                idp.load(new FileInputStream(identityProviderFile));
                String listOfIDP = (String)idp.get("IDP");
                if (StringUtil.isNotNull((String)listOfIDP)) {
                    identityProviders.addAll(StringUtil.tokenize((String)listOfIDP));
                }
            }
            catch (Exception e) {
                logger.samlMetaDataIdentityProviderLoadingError((Throwable)e);
            }
        }
        return identityProviders;
    }

    @Override
    public Set<String> getServiceProviderID() {
        HashSet<String> serviceProviders = new HashSet<String>();
        Properties sp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/serviceproviders.properties");
        File serviceProviderFile = new File(builder.toString());
        if (serviceProviderFile.exists()) {
            try {
                sp.load(new FileInputStream(serviceProviderFile));
                String listOfSP = (String)sp.get("SP");
                StringTokenizer st = new StringTokenizer(listOfSP, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    serviceProviders.add(token);
                }
            }
            catch (Exception e) {
                logger.samlMetaDataServiceProviderLoadingError((Throwable)e);
            }
        }
        return serviceProviders;
    }

    @Override
    public EntityDescriptorType load(String id) throws IOException {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        SAMLEntityDescriptorParser parser = new SAMLEntityDescriptorParser();
        try {
            return (EntityDescriptorType)parser.parse(StaxParserUtil.getXMLEventReader((InputStream)new FileInputStream(persistedFile)));
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void persist(EntityDescriptorType entity, String id) throws IOException {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        try {
            XMLStreamWriter streamWriter = StaxUtil.getXMLStreamWriter((OutputStream)new FileOutputStream(persistedFile));
            SAMLMetadataWriter writer = new SAMLMetadataWriter(streamWriter);
            writer.writeEntityDescriptor(entity);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
        logger.trace("Persisted entity descriptor into " + persistedFile.getPath());
        List<EntityDescriptorType.EDTChoiceType> edtChoiceTypeList = entity.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edtChoiceType : edtChoiceTypeList) {
            List<EntityDescriptorType.EDTDescriptorChoiceType> edtDescriptorChoiceTypeList = edtChoiceType.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptorChoiceTypeList) {
                SPSSODescriptorType spSSO;
                IDPSSODescriptorType idpSSO = edtDesc.getIdpDescriptor();
                if (idpSSO != null) {
                    this.addIdentityProvider(id);
                }
                if ((spSSO = edtDesc.getSpDescriptor()) == null) continue;
                this.addServiceProvider(id);
            }
        }
    }

    @Override
    public void delete(String id) {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> loadTrustedProviders(String id) throws IOException, ClassNotFoundException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectInputStream ois = null;
        try {
            Map trustedMap;
            ois = new ObjectInputStream(new FileInputStream(trustedFile));
            Map map = trustedMap = (Map)ois.readObject();
            return map;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistTrustedProviders(String id, Map<String, String> trusted) throws IOException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(trustedFile));
            oos.writeObject(trusted);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        logger.trace("Persisted trusted map into " + trustedFile.getPath());
    }

    @Override
    public void deleteTrustedProviders(String id) {
        File persistedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    private File validateIdAndReturnMDFile(String id) {
        String serializationExtension = ".SER";
        if (id == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:id");
        }
        if (!id.endsWith(serializationExtension)) {
            id = id + serializationExtension;
        }
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/").append(id);
        return new File(builder.toString());
    }

    private File validateIdAndReturnTrustedProvidersFile(String id) {
        if (id == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:id");
        }
        id = id + "-trusted.SER";
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/").append(id);
        return new File(builder.toString());
    }

    private void addServiceProvider(String id) {
        Properties sp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/serviceproviders.properties");
        File serviceProviderFile = new File(builder.toString());
        try {
            if (!serviceProviderFile.exists()) {
                serviceProviderFile.createNewFile();
            }
            sp.load(new FileInputStream(serviceProviderFile));
            String listOfSP = (String)sp.get("SP");
            listOfSP = listOfSP == null ? id : listOfSP + "," + id;
            sp.put("SP", listOfSP);
            sp.store(new FileWriter(serviceProviderFile), "");
        }
        catch (Exception e) {
            logger.samlMetaDataServiceProviderLoadingError((Throwable)e);
        }
    }

    private void addIdentityProvider(String id) {
        Properties idp = new Properties();
        StringBuilder builder = new StringBuilder(this.baseDirectory);
        builder.append("/identityproviders.properties");
        File idpProviderFile = new File(builder.toString());
        try {
            if (!idpProviderFile.exists()) {
                idpProviderFile.createNewFile();
            }
            idp.load(new FileInputStream(idpProviderFile));
            String listOfIDP = (String)idp.get("IDP");
            listOfIDP = listOfIDP == null ? id : listOfIDP + "," + id;
            idp.put("IDP", listOfIDP);
            idp.store(new FileWriter(idpProviderFile), "");
        }
        catch (Exception e) {
            logger.samlMetaDataIdentityProviderLoadingError((Throwable)e);
        }
    }

    @Override
    public void cleanup() {
    }
}

