/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.UnresolvedExpressionException;

public class StateParser {
    private final DefaultParsingState initialState = new DefaultParsingState("INITIAL");

    public void addState(char ch, ParsingState state) {
        this.initialState.enterState(ch, state);
    }

    public void parse(String str, ParsingStateCallbackHandler callbackHandler) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, this.initialState);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, initialState, true);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        StateParser.parse(str, callbackHandler, initialState, strict, null);
    }

    public static void parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict, CommandContext ctx) throws CommandFormatException {
        try {
            StateParser.doParse(str, callbackHandler, initialState, strict, ctx);
        }
        catch (CommandFormatException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CommandFormatException("Failed to parse '" + str + "'", t);
        }
    }

    protected static void doParse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        StateParser.doParse(str, callbackHandler, initialState, strict, null);
    }

    protected static void doParse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict, CommandContext cmdCtx) throws CommandFormatException {
        if (str == null || str.isEmpty()) {
            return;
        }
        ParsingContextImpl ctx = new ParsingContextImpl();
        ctx.initialState = initialState;
        ctx.callbackHandler = callbackHandler;
        ctx.input = str;
        ctx.strict = strict;
        ctx.cmdCtx = cmdCtx;
        ctx.parse();
    }

    static class ParsingContextImpl
    implements ParsingContext {
        private final Deque<ParsingState> stack = new ArrayDeque<ParsingState>();
        String input;
        int variableCorrection;
        String originalInput;
        int location;
        char ch;
        ParsingStateCallbackHandler callbackHandler;
        ParsingState initialState;
        boolean strict;
        CommandFormatException error;
        CommandContext cmdCtx;

        ParsingContextImpl() {
        }

        void parse() throws CommandFormatException {
            this.ch = this.input.charAt(0);
            this.originalInput = this.input;
            this.location = 0;
            this.variableCorrection = 0;
            this.initialState.getEnterHandler().handle(this);
            while (this.location < this.input.length()) {
                this.ch = this.input.charAt(this.location);
                CharacterHandler handler = this.getState().getHandler(this.ch);
                handler.handle(this);
                ++this.location;
            }
            ParsingState state = this.getState();
            while (state != this.initialState) {
                state.getEndContentHandler().handle(this);
                this.leaveState();
                state = this.getState();
            }
            this.initialState.getEndContentHandler().handle(this);
            this.initialState.getLeaveHandler().handle(this);
        }

        @Override
        public void resolveExpression(boolean systemProperty, boolean exceptionIfNotResolved) throws UnresolvedExpressionException {
            String value;
            int endIndex;
            if (this.input.charAt(this.location) != '$') {
                return;
            }
            int inputLength = this.input.length();
            if (inputLength - 1 > this.location && this.input.charAt(this.location + 1) == '{') {
                if (!systemProperty) {
                    return;
                }
                int endBrace = this.input.indexOf(125, this.location + 1);
                if (endBrace - this.location - 2 <= 0) {
                    return;
                }
                String prop = this.input.substring(this.location, endBrace + 1);
                String resolved = Util.resolveProperties(prop);
                if (!resolved.equals(prop)) {
                    StringBuilder buf = new StringBuilder(this.input.length() - prop.length() + resolved.length());
                    buf.append(this.input.substring(0, this.location)).append(resolved);
                    if (endBrace < this.input.length() - 1) {
                        buf.append(this.input.substring(endBrace + 1));
                    }
                    this.variableCorrection += resolved.length() - prop.length();
                    this.input = buf.toString();
                    this.ch = this.input.charAt(this.location);
                    return;
                }
                if (exceptionIfNotResolved) {
                    throw new UnresolvedExpressionException(prop);
                }
            }
            if ((endIndex = this.location + 1) >= this.input.length() || !Character.isJavaIdentifierStart(this.input.charAt(endIndex))) {
                return;
            }
            while (++endIndex < this.input.length() && Character.isJavaIdentifierPart(this.input.charAt(endIndex))) {
            }
            String name = this.input.substring(this.location + 1, endIndex);
            String string = value = this.cmdCtx == null ? null : this.cmdCtx.getVariable(name);
            if (value == null) {
                if (exceptionIfNotResolved) {
                    throw new UnresolvedExpressionException(name);
                }
            } else {
                StringBuilder buf = new StringBuilder(this.input.length() - name.length() + value.length());
                buf.append(this.input.substring(0, this.location)).append(value);
                if (endIndex < this.input.length()) {
                    buf.append(this.input.substring(endIndex));
                }
                this.variableCorrection += value.length() - name.length() - 1;
                this.input = buf.toString();
                this.ch = this.input.charAt(this.location);
            }
        }

        @Override
        public boolean isStrict() {
            return this.strict;
        }

        @Override
        public ParsingState getState() {
            return this.stack.isEmpty() ? this.initialState : this.stack.peek();
        }

        @Override
        public void enterState(ParsingState state) throws CommandFormatException {
            this.stack.push(state);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public ParsingState leaveState() throws CommandFormatException {
            this.stack.peek().getLeaveHandler().handle(this);
            this.callbackHandler.leavingState(this);
            ParsingState pop = this.stack.pop();
            if (!this.stack.isEmpty()) {
                this.stack.peek().getReturnHandler().handle(this);
            } else {
                this.initialState.getReturnHandler().handle(this);
            }
            return pop;
        }

        @Override
        public ParsingStateCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public char getCharacter() {
            return this.ch;
        }

        @Override
        public int getLocation() {
            return this.location - this.variableCorrection;
        }

        @Override
        public void reenterState() throws CommandFormatException {
            this.callbackHandler.leavingState(this);
            ParsingState state = this.stack.peek();
            state.getLeaveHandler().handle(this);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public boolean isEndOfContent() {
            return this.location >= this.input.length();
        }

        @Override
        public String getInput() {
            return this.originalInput;
        }

        @Override
        public void advanceLocation(int offset) throws IndexOutOfBoundsException {
            if (this.isEndOfContent()) {
                throw new IndexOutOfBoundsException("Location=" + this.location + ", offset=" + offset + ", length=" + this.input.length());
            }
            this.location += offset;
            if (this.location < this.input.length()) {
                this.ch = this.input.charAt(this.location);
            }
        }

        @Override
        public CommandFormatException getError() {
            return this.error;
        }

        @Override
        public void setError(CommandFormatException e) {
            if (this.error == null) {
                this.error = e;
            }
        }
    }
}

