/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.idm.Account;
import io.undertow.security.impl.SingleSignOn;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;

public class DistributableSingleSignOn
implements SingleSignOn {
    private final SSO<Account, String, Void> sso;
    private final SessionManagerRegistry registry;
    private final Batch batch;

    public DistributableSingleSignOn(SSO<Account, String, Void> sso, SessionManagerRegistry registry, Batch batch) {
        this.sso = sso;
        this.registry = registry;
        this.batch = batch;
    }

    public String getId() {
        return this.sso.getId();
    }

    public Account getAccount() {
        return (Account)this.sso.getAuthentication().getIdentity();
    }

    public String getMechanismName() {
        return this.sso.getAuthentication().getType().name();
    }

    public Iterator<Session> iterator() {
        Sessions sessions = this.sso.getSessions();
        Set deployments = sessions.getDeployments();
        ArrayList<Session> result = new ArrayList<Session>(deployments.size());
        for (String deployment : deployments) {
            Session session;
            String sessionId;
            SessionManager manager = this.registry.getSessionManager(deployment);
            if (manager == null || (sessionId = sessions.getSession((Object)deployment)) == null || (session = manager.getSession(sessions.getSession((Object)deployment))) == null) continue;
            result.add(session);
        }
        return result.iterator();
    }

    public boolean contains(Session session) {
        return this.sso.getSessions().getDeployments().contains(session.getSessionManager().getDeploymentName());
    }

    public void add(Session session) {
        this.sso.getSessions().addSession((Object)session.getSessionManager().getDeploymentName(), session.getId());
    }

    public void remove(Session session) {
        this.sso.getSessions().removeSession((Object)session.getSessionManager().getDeploymentName());
    }

    public Session getSession(SessionManager manager) {
        String sessionId = this.sso.getSessions().getSession((Object)manager.getDeploymentName());
        return sessionId != null ? manager.getSession(sessionId) : null;
    }

    public void close() {
        this.batch.close();
    }
}

