/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public final class QuadTreeFilter
extends Filter {
    private final List<String> quadTreeCellsIds;
    private final String fieldName;

    public QuadTreeFilter(List<String> quadTreeCellsIds, String fieldName) {
        this.quadTreeCellsIds = quadTreeCellsIds;
        this.fieldName = fieldName;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.quadTreeCellsIds.size() == 0) {
            return null;
        }
        OpenBitSet matchedDocumentsIds = new OpenBitSet((long)reader.maxDoc());
        Boolean found = false;
        for (int i = 0; i < this.quadTreeCellsIds.size(); ++i) {
            Term quadTreeCellTerm = new Term(this.fieldName, this.quadTreeCellsIds.get(i));
            TermDocs quadTreeCellsDocs = reader.termDocs(quadTreeCellTerm);
            if (quadTreeCellsDocs == null) continue;
            while (quadTreeCellsDocs.next()) {
                matchedDocumentsIds.fastSet(quadTreeCellsDocs.doc());
                found = true;
            }
        }
        if (found.booleanValue()) {
            return matchedDocumentsIds;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuadTreeFilter");
        sb.append("{quadTreeCellsIds=").append(this.quadTreeCellsIds);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

