/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.hibernate.search.SearchException;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.FileHelper;

public class HibernateSearchResourceLoader
implements ResourceLoader {
    private final String charset;

    public HibernateSearchResourceLoader() {
        this.charset = null;
    }

    public HibernateSearchResourceLoader(String charset) {
        this.charset = charset;
    }

    public InputStream openResource(String resource) throws IOException {
        return FileHelper.openResource(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLines(String resource) throws IOException {
        InputStream stream = this.openResource(resource);
        if (stream == null) {
            throw new SearchException("Resource not found: " + resource);
        }
        try {
            InputStreamReader charsetAwareReader = this.charset == null ? new InputStreamReader(stream) : new InputStreamReader(stream, this.charset);
            ArrayList<String> results = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(charsetAwareReader);
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() != 0 && !line.startsWith("#")) {
                        results.add(line);
                    }
                    line = reader.readLine();
                }
            }
            finally {
                FileHelper.closeResource(reader);
            }
            List<String> list = Collections.unmodifiableList(results);
            return list;
        }
        finally {
            FileHelper.closeResource(stream);
        }
    }

    public Object newInstance(String cname, String ... subpackages) {
        if (subpackages != null && subpackages.length > 0) {
            throw new UnsupportedOperationException("newInstance(classname, packages) not implemented");
        }
        Object instance = ClassLoaderHelper.instanceFromName(Object.class, cname, this.getClass(), "Solr resource");
        if (instance instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)instance).inform((ResourceLoader)this);
        }
        return instance;
    }
}

