/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.service.SarMessages;
import org.jboss.as.service.descriptor.JBossServiceXmlDescriptor;
import org.jboss.as.service.descriptor.JBossServiceXmlDescriptorParser;
import org.jboss.as.service.descriptor.ParseResult;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class ServiceDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    static final String SERVICE_DESCRIPTOR_PATH = "META-INF/jboss-service.xml";
    static final String SERVICE_DESCRIPTOR_SUFFIX = "-service.xml";
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block11: {
            VirtualFile deploymentRoot = ((ResourceRoot)phaseContext.getDeploymentUnit().getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            VirtualFile serviceXmlFile = null;
            if (deploymentRoot.isDirectory()) {
                serviceXmlFile = deploymentRoot.getChild(SERVICE_DESCRIPTOR_PATH);
            } else if (deploymentRoot.getName().toLowerCase(Locale.ENGLISH).endsWith(SERVICE_DESCRIPTOR_SUFFIX)) {
                serviceXmlFile = deploymentRoot;
            }
            if (serviceXmlFile == null || !serviceXmlFile.exists()) {
                return;
            }
            XMLMapper xmlMapper = XMLMapper.Factory.create();
            JBossServiceXmlDescriptorParser jBossServiceXmlDescriptorParser = new JBossServiceXmlDescriptorParser(JBossDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)phaseContext.getDeploymentUnit()));
            xmlMapper.registerRootElement(new QName("urn:jboss:service:7.0", "server"), (XMLElementReader)jBossServiceXmlDescriptorParser);
            xmlMapper.registerRootElement(new QName(null, "server"), (XMLElementReader)jBossServiceXmlDescriptorParser);
            InputStream xmlStream = null;
            try {
                xmlStream = serviceXmlFile.openStream();
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(xmlStream);
                ParseResult result = new ParseResult();
                xmlMapper.parseDocument(result, reader);
                JBossServiceXmlDescriptor xmlDescriptor = (JBossServiceXmlDescriptor)result.getResult();
                if (xmlDescriptor != null) {
                    phaseContext.getDeploymentUnit().putAttachment(JBossServiceXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
                    break block11;
                }
                throw SarMessages.MESSAGES.failedXmlParsing(serviceXmlFile);
            }
            catch (Exception e) {
                throw SarMessages.MESSAGES.failedXmlParsing(e, serviceXmlFile);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

