/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.marshalling.MarshalledValueFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContextFactory;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;
import org.wildfly.clustering.ejb.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanCacheConfigurationService;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManager;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanFactory;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupFactory;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.spi.CacheServiceNames;
import org.wildfly.clustering.spi.ChannelServiceNames;

public class InfinispanBeanManagerFactory<G, I, T>
extends AbstractService<BeanManagerFactory<G, I, T, TransactionBatch>>
implements BeanManagerFactory<G, I, T, TransactionBatch> {
    private final BeanContext context;
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();
    private final InjectedValue<VersionedMarshallingConfiguration> config = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduler = new InjectedValue();
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final BeanPassivationConfiguration passivationConfig;
    private final InjectedValue<NodeFactory> nodeFactory = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();

    public static <G, I, T> ServiceBuilder<BeanManagerFactory<G, I, T, TransactionBatch>> build(String name, ServiceTarget target, ServiceName serviceName, BeanManagerFactoryBuilderConfiguration config, BeanContext context) {
        InfinispanBeanManagerFactory<G, I, T> factory = new InfinispanBeanManagerFactory<G, I, T>(context, (BeanPassivationConfiguration)config);
        String containerName = config.getContainerName();
        ServiceName deploymentUnitServiceName = context.getDeploymentUnitServiceName();
        return target.addService(serviceName, factory).addDependency(CacheService.getServiceName((String)containerName, (String)BeanCacheConfigurationService.getCacheName(context.getDeploymentUnitServiceName())), Cache.class, factory.cache).addDependency(KeyAffinityServiceFactoryService.getServiceName((String)containerName), KeyAffinityServiceFactory.class, factory.affinityFactory).addDependency(deploymentUnitServiceName.append(new String[]{"marshalling"}), VersionedMarshallingConfiguration.class, factory.config).addDependency(deploymentUnitServiceName.append(new String[]{name, "expiration"}), ScheduledExecutorService.class, factory.scheduler).addDependency(deploymentUnitServiceName.append(new String[]{name, "eviction"}), Executor.class, factory.executor).addDependency(ChannelServiceNames.COMMAND_DISPATCHER.getServiceName(containerName), CommandDispatcherFactory.class, factory.dispatcherFactory).addDependency(CacheServiceNames.REGISTRY.getServiceName(containerName), Registry.class, factory.registry).addDependency(CacheServiceNames.NODE_FACTORY.getServiceName(containerName), NodeFactory.class, factory.nodeFactory);
    }

    private InfinispanBeanManagerFactory(BeanContext context, BeanPassivationConfiguration passivationConfig) {
        this.context = context;
        this.passivationConfig = passivationConfig;
    }

    public BeanManager<G, I, T, TransactionBatch> createBeanManager(IdentifierFactory<G> groupIdentifierFactory, IdentifierFactory<I> beanIdentifierFactory, final PassivationListener<T> passivationListener, final RemoveListener<T> removeListener) {
        SimpleMarshallingContext context = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)this.config.getValue(), this.context.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)context);
        Cache groupCache = (Cache)this.cache.getValue();
        org.infinispan.configuration.cache.Configuration config = groupCache.getCacheConfiguration();
        InfinispanBeanGroupFactory groupFactory = new InfinispanBeanGroupFactory(groupCache, (MarshalledValueFactory<MarshallingContext>)factory, (MarshallingContext)context);
        SimpleConfiguration groupConfiguration = new SimpleConfiguration(groupCache, groupFactory, groupIdentifierFactory);
        Cache beanCache = (Cache)this.cache.getValue();
        final String beanName = this.context.getBeanName();
        final boolean evictionAllowed = config.persistence().usingStores();
        boolean passivationEnabled = evictionAllowed && config.persistence().passivation();
        final boolean persistent = config.clustering().cacheMode().isClustered() || evictionAllowed && !passivationEnabled;
        InfinispanBeanFactory beanFactory = new InfinispanBeanFactory(beanName, groupFactory, beanCache, this.context.getTimeout(), persistent ? passivationListener : null);
        SimpleConfiguration beanConfiguration = new SimpleConfiguration(beanCache, beanFactory, beanIdentifierFactory);
        final NodeFactory nodeFactory = (NodeFactory)this.nodeFactory.getValue();
        final Registry registry = (Registry)this.registry.getValue();
        final KeyAffinityServiceFactory affinityFactory = (KeyAffinityServiceFactory)this.affinityFactory.getValue();
        final CommandDispatcherFactory dispatcherFactory = (CommandDispatcherFactory)this.dispatcherFactory.getValue();
        final Time timeout = this.context.getTimeout();
        final ScheduledExecutorService scheduler = (ScheduledExecutorService)this.scheduler.getValue();
        final ExpirationConfiguration expiration = new ExpirationConfiguration<T>(){

            @Override
            public Time getTimeout() {
                return timeout;
            }

            @Override
            public RemoveListener<T> getRemoveListener() {
                return removeListener;
            }

            @Override
            public ScheduledExecutorService getExecutor() {
                return scheduler;
            }
        };
        final Executor executor = (Executor)this.executor.getValue();
        final BeanPassivationConfiguration passivationConfig = this.passivationConfig;
        final PassivationConfiguration passivation = new PassivationConfiguration<T>(){

            @Override
            public PassivationListener<T> getPassivationListener() {
                return passivationListener;
            }

            @Override
            public boolean isEvictionAllowed() {
                return evictionAllowed;
            }

            @Override
            public boolean isPersistent() {
                return persistent;
            }

            @Override
            public BeanPassivationConfiguration getConfiguration() {
                return passivationConfig;
            }

            @Override
            public Executor getExecutor() {
                return executor;
            }
        };
        InfinispanBeanManagerConfiguration configuration = new InfinispanBeanManagerConfiguration<T>(){

            @Override
            public String getBeanName() {
                return beanName;
            }

            @Override
            public KeyAffinityServiceFactory getAffinityFactory() {
                return affinityFactory;
            }

            @Override
            public Registry<String, ?> getRegistry() {
                return registry;
            }

            @Override
            public NodeFactory<Address> getNodeFactory() {
                return nodeFactory;
            }

            @Override
            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return dispatcherFactory;
            }

            @Override
            public ExpirationConfiguration<T> getExpirationConfiguration() {
                return expiration;
            }

            @Override
            public PassivationConfiguration<T> getPassivationConfiguration() {
                return passivation;
            }
        };
        return new InfinispanBeanManager(configuration, beanConfiguration, groupConfiguration);
    }

    public BeanManagerFactory<G, I, T, TransactionBatch> getValue() {
        return this;
    }

    private static class SimpleConfiguration<I, K, V, F>
    implements Configuration<I, K, V, F> {
        private final F factory;
        private final Cache<K, V> cache;
        private final IdentifierFactory<I> identifierFactory;

        SimpleConfiguration(Cache<K, V> cache, F factory, IdentifierFactory<I> identifierFactory) {
            this.factory = factory;
            this.cache = cache;
            this.identifierFactory = identifierFactory;
        }

        @Override
        public F getFactory() {
            return this.factory;
        }

        @Override
        public Cache<K, V> getCache() {
            return this.cache;
        }

        @Override
        public IdentifierFactory<I> getIdentifierFactory() {
            return this.identifierFactory;
        }
    }
}

