/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.LockingMode;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBean;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class InfinispanBeanFactory<G, I, T>
implements BeanFactory<G, I, T> {
    private final String beanName;
    private final BeanGroupFactory<G, I, T> groupFactory;
    private final Cache<BeanKey<I>, BeanEntry<G>> cache;
    private final Time timeout;
    private final PassivationListener<T> listener;

    public InfinispanBeanFactory(String beanName, BeanGroupFactory<G, I, T> groupFactory, Cache<BeanKey<I>, BeanEntry<G>> beanCache, Time timeout, PassivationListener<T> listener) {
        this.beanName = beanName;
        this.groupFactory = groupFactory;
        this.cache = beanCache;
        this.timeout = timeout;
        this.listener = listener;
    }

    @Override
    public BeanKey<I> createKey(I id) {
        return new InfinispanBeanKey<I>(this.beanName, id);
    }

    @Override
    public Bean<G, I, T> createBean(I id, BeanEntry<G> entry) {
        G groupId = entry.getGroupId();
        BeanGroupEntry groupEntry = (BeanGroupEntry)this.groupFactory.findValue(groupId);
        if (groupEntry == null) {
            throw InfinispanEjbLogger.ROOT_LOGGER.invalidBeanGroup(id, groupId);
        }
        BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, groupEntry);
        Mutator mutator = entry.getLastAccessedTime() == null ? Mutator.PASSIVE : new BeanMutator<G, I>(this.cache, this.createKey(id), entry);
        return new InfinispanBean<G, I, T>(id, entry, group, mutator, this, this.timeout, this.listener);
    }

    public BeanEntry<G> findValue(I id) {
        TransactionConfiguration transaction = this.cache.getCacheConfiguration().transaction();
        boolean pessimistic = transaction.transactionMode().isTransactional() && transaction.lockingMode() == LockingMode.PESSIMISTIC;
        AdvancedCache cache = pessimistic ? this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : this.cache;
        return (BeanEntry)cache.get(this.createKey(id));
    }

    @Override
    public BeanEntry<G> createValue(I id, G groupId) {
        InfinispanBeanEntry<G> entry = new InfinispanBeanEntry<G>(groupId);
        InfinispanBeanEntry<G> existing = (InfinispanBeanEntry<G>)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent(this.createKey(id), entry);
        return existing != null ? existing : entry;
    }

    @Override
    public void remove(I id, RemoveListener<T> listener) {
        BeanEntry entry = (BeanEntry)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove(this.createKey(id));
        if (entry != null) {
            Object groupId = entry.getGroupId();
            try (BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, (BeanGroupEntry)this.groupFactory.findValue(groupId));){
                T bean = group.removeBean(id);
                if (listener != null) {
                    listener.removed(bean);
                }
            }
        }
    }

    public void evict(I id) {
        BeanKey<I> key = this.createKey(id);
        BeanEntry entry = (BeanEntry)this.cache.get(key);
        if (entry != null) {
            try {
                this.cache.evict(key);
            }
            catch (Throwable e) {
                InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBean(e, id);
            }
            this.groupFactory.evict(entry.getGroupId());
        }
    }

    private static class BeanMutator<G, I>
    implements Mutator {
        private final Cache<BeanKey<I>, BeanEntry<G>> cache;
        private final BeanKey<I> key;
        private final BeanEntry<G> entry;

        BeanMutator(Cache<BeanKey<I>, BeanEntry<G>> cache, BeanKey<I> key, BeanEntry<G> entry) {
            this.cache = cache;
            this.key = key;
            this.entry = entry;
        }

        public void mutate() {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(this.key, this.entry);
        }
    }
}

