/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Http2FrameHeaderParser;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class Http2PushBackParser {
    private byte[] pushedBackData;
    private boolean finished;
    private int remainingData;

    public Http2PushBackParser(int frameLength) {
        this.remainingData = frameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ByteBuffer data, Http2FrameHeaderParser headerParser) throws IOException {
        int used = 0;
        ByteBuffer dataToParse = data;
        int oldLimit = dataToParse.limit();
        try {
            if (this.pushedBackData != null) {
                dataToParse = ByteBuffer.wrap(new byte[this.pushedBackData.length + data.remaining()]);
                dataToParse.put(this.pushedBackData);
                dataToParse.put(data);
                dataToParse.flip();
                oldLimit = dataToParse.limit();
            }
            if (dataToParse.remaining() > this.remainingData) {
                dataToParse.limit(dataToParse.position() + this.remainingData);
            }
            int rem = dataToParse.remaining();
            this.handleData(dataToParse, headerParser);
            used = rem - dataToParse.remaining();
        }
        finally {
            if (this.finished) {
                dataToParse.limit(oldLimit);
                return;
            }
            int leftOver = dataToParse.remaining();
            if (leftOver > 0) {
                this.pushedBackData = new byte[leftOver];
                dataToParse.get(this.pushedBackData);
            } else {
                this.pushedBackData = null;
            }
            dataToParse.limit(oldLimit);
            this.remainingData -= used;
            if (this.remainingData == 0) {
                this.finished = true;
            }
        }
    }

    protected abstract void handleData(ByteBuffer var1, Http2FrameHeaderParser var2) throws IOException;

    public boolean isFinished() {
        return this.finished;
    }

    protected void finish() {
        this.finished = true;
    }
}

