/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

public class Http2StreamSourceChannel
extends AbstractHttp2StreamSourceChannel {
    private boolean headersEndStream = false;
    private boolean rst = false;
    private final HeaderMap headers;
    private final int streamId;
    private HeaderMap newHeaders = null;
    private Http2HeadersStreamSinkChannel response;
    private int flowControlWindow;
    private ChannelListener<Http2StreamSourceChannel> completionListener;

    Http2StreamSourceChannel(Http2Channel framedChannel, Pooled<ByteBuffer> data, long frameDataRemaining, HeaderMap headers, int streamId) {
        super(framedChannel, data, frameDataRemaining);
        this.headers = headers;
        this.streamId = streamId;
        this.flowControlWindow = framedChannel.getInitialReceiveWindowSize();
    }

    @Override
    protected void handleHeaderData(FrameHeaderData headerData) {
        this.handleFinalFrame((Http2FrameHeaderParser)headerData);
    }

    void handleFinalFrame(Http2FrameHeaderParser headerData) {
        Http2FrameHeaderParser data = headerData;
        if (data.type == 0) {
            if (Bits.anyAreSet((int)data.flags, (int)1)) {
                this.lastFrame();
            }
        } else if (data.type == 1) {
            if (Bits.allAreSet((int)data.flags, (int)1)) {
                if (Bits.allAreSet((int)data.flags, (int)4)) {
                    this.lastFrame();
                } else {
                    this.headersEndStream = true;
                }
            }
        } else if (this.headersEndStream && data.type == 9 && Bits.anyAreSet((int)data.flags, (int)4)) {
            this.lastFrame();
        }
    }

    public Http2HeadersStreamSinkChannel getResponseChannel() {
        if (this.response != null) {
            return this.response;
        }
        this.response = new Http2HeadersStreamSinkChannel(this.getHttp2Channel(), this.streamId);
        this.getHttp2Channel().registerStreamSink(this.response);
        return this.response;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.handleNewHeaders();
        int read = super.read(dst);
        this.updateFlowControlWindow(read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts, offset, length);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        this.handleNewHeaders();
        long read = super.read(dsts);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel streamSinkChannel) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(count, throughBuffer, streamSinkChannel);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        this.handleNewHeaders();
        long read = super.transferTo(position, count, target);
        this.updateFlowControlWindow((int)read);
        return read;
    }

    private synchronized void handleNewHeaders() {
        if (this.newHeaders != null) {
            for (HeaderValues header : this.newHeaders) {
                this.headers.addAll(header.getHeaderName(), header);
            }
            this.newHeaders = null;
        }
    }

    synchronized void addNewHeaders(HeaderMap headers) {
        if (this.newHeaders != null) {
            this.newHeaders = headers;
        } else {
            for (HeaderValues header : headers) {
                this.newHeaders.addAll(header.getHeaderName(), header);
            }
        }
    }

    private void updateFlowControlWindow(int read) {
        if (read <= 0) {
            return;
        }
        this.flowControlWindow -= read;
        Http2Channel spdyChannel = this.getHttp2Channel();
        spdyChannel.updateReceiveFlowControlWindow(read);
        int initialWindowSize = spdyChannel.getInitialReceiveWindowSize();
        if (this.flowControlWindow < initialWindowSize / 2) {
            int delta = initialWindowSize - this.flowControlWindow;
            this.flowControlWindow += delta;
            spdyChannel.sendUpdateWindowSize(this.streamId, delta);
        }
    }

    @Override
    protected void complete() throws IOException {
        super.complete();
        if (this.completionListener != null) {
            ChannelListeners.invokeChannelListener((Channel)((Object)this), this.completionListener);
        }
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    public ChannelListener<Http2StreamSourceChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<Http2StreamSourceChannel> completionListener) {
        this.completionListener = completionListener;
    }

    @Override
    void rstStream() {
        if (this.rst) {
            return;
        }
        this.rst = true;
        this.markStreamBroken();
        this.getHttp2Channel().sendRstStream(this.streamId, 8);
    }

    @Override
    protected void channelForciblyClosed() {
        if (this.completionListener != null) {
            this.completionListener.handleEvent((Channel)((Object)this));
        }
        this.rstStream();
    }

    public int getStreamId() {
        return this.streamId;
    }
}

