/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.client.ClientConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ExclusivityChecker;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyTarget;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.util.AttachmentKey;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.xnio.IoUtils;

class ModClusterProxyClient
implements ProxyClient {
    private final AttachmentKey<ExclusiveConnectionHolder> exclusiveConnectionKey = AttachmentKey.create(ExclusiveConnectionHolder.class);
    private final ExclusivityChecker exclusivityChecker;
    private final ModClusterContainer container;

    protected ModClusterProxyClient(ExclusivityChecker exclusivityChecker, ModClusterContainer container) {
        this.exclusivityChecker = exclusivityChecker;
        this.container = container;
    }

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        return this.container.findTarget(exchange);
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        ModClusterProxyTarget proxyTarget;
        Node node;
        final ExclusiveConnectionHolder holder = exchange.getConnection().getAttachment(this.exclusiveConnectionKey);
        if (holder != null && holder.connection.getConnection().isOpen()) {
            callback.completed(exchange, holder.connection);
            return;
        }
        if (!(target instanceof ModClusterProxyTarget)) {
            callback.failed(exchange);
        }
        if ((node = (proxyTarget = (ModClusterProxyTarget)target).findNode(exchange)) == null) {
            callback.failed(exchange);
        } else if (holder != null || this.exclusivityChecker != null && this.exclusivityChecker.isExclusivityRequired(exchange)) {
            node.getConnectionPool().connect(target, exchange, new ProxyCallback<ProxyConnection>(){

                @Override
                public void failed(HttpServerExchange exchange) {
                    callback.failed(exchange);
                }

                @Override
                public void completed(HttpServerExchange exchange, ProxyConnection result) {
                    if (holder != null) {
                        holder.connection = result;
                    } else {
                        final ExclusiveConnectionHolder newHolder = new ExclusiveConnectionHolder();
                        newHolder.connection = result;
                        ServerConnection connection = exchange.getConnection();
                        connection.putAttachment(ModClusterProxyClient.this.exclusiveConnectionKey, newHolder);
                        connection.addCloseListener(new ServerConnection.CloseListener(){

                            @Override
                            public void closed(ServerConnection connection) {
                                ClientConnection clientConnection = newHolder.connection.getConnection();
                                if (clientConnection.isOpen()) {
                                    IoUtils.safeClose((Closeable)clientConnection);
                                }
                            }
                        });
                    }
                    callback.completed(exchange, result);
                }
            }, timeout, timeUnit, true);
        } else {
            node.getConnectionPool().connect(target, exchange, callback, timeout, timeUnit, false);
        }
    }

    private static class ExclusiveConnectionHolder {
        private ProxyConnection connection;

        private ExclusiveConnectionHolder() {
        }
    }
}

