/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.protocol.stomp.FrameEventListener;
import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.protocol.stomp.HornetQStompProtocolMessageBundle;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompProtocolManager;
import org.hornetq.core.protocol.stomp.StompSession;
import org.hornetq.core.protocol.stomp.StompSubscription;
import org.hornetq.core.protocol.stomp.StompVersions;
import org.hornetq.core.protocol.stomp.VersionedStompFrameHandler;
import org.hornetq.core.protocol.stomp.v10.StompFrameHandlerV10;
import org.hornetq.core.protocol.stomp.v12.StompFrameHandlerV12;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.utils.ConfigurationHelper;
import org.hornetq.utils.VersionLoader;

public final class StompConnection
implements RemotingConnection {
    protected static final String CONNECTION_ID_PROP = "__HQ_CID";
    private static final String SERVER_NAME = "HornetQ/" + VersionLoader.getVersion().getFullVersion() + " HornetQ Messaging Engine";
    private final StompProtocolManager manager;
    private final Connection transportConnection;
    private String login;
    private String passcode;
    private String clientID;
    private boolean valid;
    private boolean destroyed = false;
    private final long creationTime;
    private final Acceptor acceptorUsed;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private final Object failLock = new Object();
    private boolean dataReceived;
    private final boolean enableMessageID;
    private StompVersions version;
    private VersionedStompFrameHandler frameHandler;
    private boolean initialized;
    private FrameEventListener stompListener;
    private final Object sendLock = new Object();
    private int minLargeMessageSize;

    public StompFrame decode(HornetQBuffer buffer) throws HornetQStompException {
        StompFrame frame = null;
        try {
            frame = this.frameHandler.decode(buffer);
        }
        catch (HornetQStompException e) {
            switch (e.getCode()) {
                case 1: {
                    if (this.version != null) {
                        throw e;
                    }
                    this.frameHandler = new StompFrameHandlerV12(this);
                    buffer.resetReaderIndex();
                    frame = this.decode(buffer);
                    break;
                }
                case 2: {
                    this.frameHandler.onError(e);
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        return frame;
    }

    public boolean hasBytes() {
        return this.frameHandler.hasBytes();
    }

    StompConnection(Acceptor acceptorUsed, Connection transportConnection, StompProtocolManager manager) {
        this.transportConnection = transportConnection;
        this.manager = manager;
        this.frameHandler = new StompFrameHandlerV10(this);
        this.creationTime = System.currentTimeMillis();
        this.acceptorUsed = acceptorUsed;
        this.enableMessageID = ConfigurationHelper.getBooleanProperty((String)"stomp-enable-message-id", (boolean)false, (Map)acceptorUsed.getConfiguration());
        this.minLargeMessageSize = ConfigurationHelper.getIntProperty((String)"stomp-min-large-message-size", (int)102400, (Map)acceptorUsed.getConfiguration());
    }

    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    protected synchronized void setDataReceived() {
        this.dataReceived = true;
    }

    public synchronized boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public void checkDestination(String destination) throws HornetQStompException {
        if (!this.manager.destinationExists(destination)) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.destinationNotExist(destination);
        }
    }

    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer((int)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
        }
        this.destroyed = true;
        this.internalClose();
        object = this.sendLock;
        synchronized (object) {
            this.callClosingListeners();
        }
    }

    Acceptor getAcceptorUsed() {
        return this.acceptorUsed;
    }

    private void internalClose() {
        this.transportConnection.close();
        this.manager.cleanup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(HornetQException me) {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        HornetQServerLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.internalClose();
    }

    public void flush() {
    }

    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    public Object getID() {
        return this.transportConnection.getID();
    }

    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        this.manager.handleBuffer(this, buffer);
    }

    public String getLogin() {
        return this.login;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    private void callFailureListeners(HornetQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public void negotiateVersion(StompFrame frame) throws HornetQStompException {
        String acceptVersion = frame.getHeader("accept-version");
        if (acceptVersion == null) {
            this.version = StompVersions.V1_0;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(acceptVersion, ",");
            HashSet<String> requestVersions = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                requestVersions.add(tokenizer.nextToken());
            }
            if (requestVersions.contains("1.2")) {
                this.version = StompVersions.V1_2;
            } else if (requestVersions.contains("1.1")) {
                this.version = StompVersions.V1_1;
            } else if (requestVersions.contains("1.0")) {
                this.version = StompVersions.V1_0;
            } else {
                HornetQStompException error = HornetQStompProtocolMessageBundle.BUNDLE.versionNotSupported(acceptVersion);
                error.addHeader("version", acceptVersion);
                error.addHeader("content-type", "text/plain");
                error.setBody("Supported protocol version are " + this.manager.getSupportedVersionsAsString());
                error.setDisconnect(true);
                throw error;
            }
        }
        if (this.version != StompVersions.V1_0) {
            VersionedStompFrameHandler newHandler = VersionedStompFrameHandler.getHandler(this, this.version);
            newHandler.initDecoder(this.frameHandler);
            this.frameHandler = newHandler;
        }
        this.initialized = true;
    }

    public void setHost(String host) throws HornetQStompException {
        if (host == null) {
            HornetQStompException error = HornetQStompProtocolMessageBundle.BUNDLE.nullHostHeader();
            error.setBody(HornetQStompProtocolMessageBundle.BUNDLE.hostCannotBeNull());
            throw error;
        }
        String localHost = this.manager.getVirtualHostName();
        if (!host.equals(localHost)) {
            HornetQStompException error = HornetQStompProtocolMessageBundle.BUNDLE.hostNotMatch();
            error.setBody(HornetQStompProtocolMessageBundle.BUNDLE.hostNotMatchDetails(host));
            throw error;
        }
    }

    public void handleFrame(StompFrame request) {
        StompFrame reply = null;
        if (this.stompListener != null) {
            this.stompListener.requestAccepted(request);
        }
        String cmd = request.getCommand();
        try {
            if (this.isDestroyed()) {
                throw HornetQStompProtocolMessageBundle.BUNDLE.connectionDestroyed();
            }
            if (!this.initialized) {
                if (!"CONNECT".equals(cmd) && !"STOMP".equals(cmd)) {
                    throw HornetQStompProtocolMessageBundle.BUNDLE.connectionNotEstablished();
                }
                this.negotiateVersion(request);
            }
            reply = this.frameHandler.handleFrame(request);
        }
        catch (HornetQStompException e) {
            reply = e.getFrame();
        }
        if (reply != null) {
            this.sendFrame(reply);
        }
        if ("DISCONNECT".equals(cmd)) {
            this.disconnect(false);
        }
    }

    public void sendFrame(StompFrame frame) {
        this.manager.sendReply(this, frame);
    }

    public boolean validateUser(String login1, String passcode1) {
        this.valid = this.manager.validateUser(login1, passcode1);
        if (this.valid) {
            this.login = login1;
            this.passcode = passcode1;
        }
        return this.valid;
    }

    public ServerMessageImpl createServerMessage() {
        return this.manager.createServerMessage();
    }

    public StompSession getSession(String txID) throws HornetQStompException {
        StompSession session = null;
        try {
            session = txID == null ? this.manager.getSession(this) : this.manager.getTransactedSession(this, txID);
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorGetSession(e);
        }
        return session;
    }

    protected void validate() throws HornetQStompException {
        if (!this.valid) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.invalidConnection();
        }
    }

    protected void sendServerMessage(ServerMessageImpl message, String txID) throws HornetQStompException {
        StompSession stompSession = this.getSession(txID);
        if (stompSession.isNoLocal()) {
            message.putStringProperty(CONNECTION_ID_PROP, this.getID().toString());
        }
        if (this.enableMessageID()) {
            message.putStringProperty("hqMessageId", "STOMP" + message.getMessageID());
        }
        try {
            if (this.minLargeMessageSize == -1 || message.getBodyBuffer().writerIndex() < this.minLargeMessageSize) {
                stompSession.sendInternal(message, false);
            } else {
                stompSession.sendInternalLarge(message, false);
            }
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorSendMessage(message, e);
        }
    }

    public void disconnect(boolean criticalError) {
        this.destroy();
    }

    protected void beginTransaction(String txID) throws HornetQStompException {
        try {
            this.manager.beginTransaction(this, txID);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorBeginTx(txID, e);
        }
    }

    public void commitTransaction(String txID) throws HornetQStompException {
        try {
            this.manager.commitTransaction(this, txID);
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorCommitTx(txID, e);
        }
    }

    public void abortTransaction(String txID) throws HornetQStompException {
        try {
            this.manager.abortTransaction(this, txID);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorAbortTx(txID, e);
        }
    }

    void subscribe(String destination, String selector, String ack, String id, String durableSubscriptionName, boolean noLocal) throws HornetQStompException {
        if (noLocal) {
            String noLocalFilter = "__HQ_CID <> '" + this.getID().toString() + "'";
            selector = selector == null ? noLocalFilter : selector + " AND " + noLocalFilter;
        }
        if (ack == null) {
            ack = "auto";
        }
        String subscriptionID = null;
        if (id != null) {
            subscriptionID = id;
        } else {
            if (destination == null) {
                throw HornetQStompProtocolMessageBundle.BUNDLE.noDestination();
            }
            subscriptionID = "subscription/" + destination;
        }
        try {
            this.manager.createSubscription(this, subscriptionID, durableSubscriptionName, destination, selector, ack, noLocal);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorCreatSubscription(subscriptionID, e);
        }
    }

    public void unsubscribe(String subscriptionID, String durableSubscriberName) throws HornetQStompException {
        try {
            this.manager.unsubscribe(this, subscriptionID, durableSubscriberName);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorUnsubscrib(subscriptionID, e);
        }
    }

    public void acknowledge(String messageID, String subscriptionID) throws HornetQStompException {
        try {
            this.manager.acknowledge(this, messageID, subscriptionID);
        }
        catch (HornetQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw HornetQStompProtocolMessageBundle.BUNDLE.errorAck(messageID, e);
        }
    }

    public String getVersion() {
        return String.valueOf((Object)this.version);
    }

    public String getHornetQServerName() {
        return SERVER_NAME;
    }

    public StompFrame createStompMessage(ServerMessage serverMessage, StompSubscription subscription, int deliveryCount) throws Exception {
        return this.frameHandler.createMessageFrame(serverMessage, subscription, deliveryCount);
    }

    public void addStompEventListener(FrameEventListener listener) {
        this.stompListener = listener;
    }

    public void ping(StompFrame pingFrame) {
        this.manager.sendReply(this, pingFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalSend(StompFrame frame) throws Exception {
        HornetQBuffer buffer = frame.toHornetQBuffer();
        Object object = this.sendLock;
        synchronized (object) {
            this.getTransportConnection().write(buffer, false, false);
        }
        if (this.stompListener != null) {
            this.stompListener.replySent(frame);
        }
    }

    public VersionedStompFrameHandler getFrameHandler() {
        return this.frameHandler;
    }

    public boolean enableMessageID() {
        return this.enableMessageID;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }
}

