/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.BatcherFactory;
import org.jboss.as.clustering.infinispan.CacheContainer;
import org.jboss.as.clustering.infinispan.InfinispanBatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;

public class DefaultCacheContainer
extends AbstractDelegatingEmbeddedCacheManager
implements CacheContainer {
    private final BatcherFactory batcherFactory;
    private final String defaultCacheName;

    public DefaultCacheContainer(GlobalConfiguration global, String defaultCacheName) {
        this((EmbeddedCacheManager)new DefaultCacheManager(global, null, false), defaultCacheName);
    }

    public DefaultCacheContainer(GlobalConfiguration global, Configuration config, String defaultCacheName) {
        this((EmbeddedCacheManager)new DefaultCacheManager(global, config, false), defaultCacheName);
    }

    public DefaultCacheContainer(EmbeddedCacheManager container, String defaultCacheName) {
        this(container, defaultCacheName, new InfinispanBatcherFactory());
    }

    public DefaultCacheContainer(EmbeddedCacheManager container, String defaultCacheName, BatcherFactory batcherFactory) {
        super(container);
        this.defaultCacheName = defaultCacheName;
        this.batcherFactory = batcherFactory;
    }

    @Override
    public String getDefaultCacheName() {
        return this.defaultCacheName;
    }

    public Configuration defineConfiguration(String cacheName, Configuration configuration) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), configuration);
    }

    public Configuration defineConfiguration(String cacheName, String templateCacheName, Configuration configurationOverride) {
        return this.cm.defineConfiguration(this.getCacheName(cacheName), this.getCacheName(templateCacheName), configurationOverride);
    }

    public Configuration getCacheConfiguration(String name) {
        return this.cm.getCacheConfiguration(this.getCacheName(name));
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache(this.defaultCacheName);
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, true);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
        Cache cache = this.cm.getCache(this.getCacheName(cacheName), createIfAbsent);
        return cache != null ? new DelegatingCache((EmbeddedCacheManager)this, this.batcherFactory, cache) : null;
    }

    public Set<String> getCacheNames() {
        return new HashSet<String>(this.cm.getCacheNames());
    }

    public boolean isDefaultRunning() {
        return this.cm.isRunning(this.defaultCacheName);
    }

    public boolean isRunning(String cacheName) {
        return this.cm.isRunning(this.getCacheName(cacheName));
    }

    public boolean cacheExists(String cacheName) {
        return this.cm.cacheExists(this.getCacheName(cacheName));
    }

    public void removeCache(String cacheName) {
        this.cm.removeCache(this.getCacheName(cacheName));
    }

    public EmbeddedCacheManager startCaches(String ... names) {
        LinkedHashSet<String> cacheNames = new LinkedHashSet<String>();
        for (String name : names) {
            cacheNames.add(this.getCacheName(name));
        }
        this.cm.startCaches(cacheNames.toArray(new String[cacheNames.size()]));
        return this;
    }

    private String getCacheName(String name) {
        return name == null || name.equals("default") ? this.defaultCacheName : name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.cm.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
    }

    private static class DelegatingCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        private static final ThreadLocal<Batch> CURRENT_BATCH = new ThreadLocal();
        private final EmbeddedCacheManager manager;
        private final Batcher<? extends Batch> batcher;

        DelegatingCache(final EmbeddedCacheManager manager, final BatcherFactory batcherFactory, AdvancedCache<K, V> cache) {
            super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                    return new DelegatingCache(manager, batcherFactory, cache);
                }
            });
            this.manager = manager;
            this.batcher = batcherFactory.createBatcher((Cache<?, ?>)cache);
        }

        DelegatingCache(EmbeddedCacheManager manager, BatcherFactory batcherFactory, Cache<K, V> cache) {
            this(manager, batcherFactory, cache.getAdvancedCache());
        }

        public EmbeddedCacheManager getCacheManager() {
            return this.manager;
        }

        public boolean startBatch() {
            if (this.batcher == null) {
                return false;
            }
            Batch batch = CURRENT_BATCH.get();
            if (batch != null) {
                return false;
            }
            CURRENT_BATCH.set(this.batcher.createBatch());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endBatch(boolean successful) {
            Batch batch = CURRENT_BATCH.get();
            if (batch != null) {
                try {
                    if (successful) {
                        batch.close();
                    } else {
                        batch.discard();
                    }
                }
                finally {
                    CURRENT_BATCH.remove();
                }
            }
        }

        public boolean equals(Object object) {
            return object == this || object == this.cache;
        }

        public int hashCode() {
            return this.cache.hashCode();
        }
    }
}

