/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.infinispan.configuration.cache.CacheMode;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYCLINF", length=4)
public interface InfinispanLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.jboss.as.clustering.infinispan";
    public static final InfinispanLogger ROOT_LOGGER = (InfinispanLogger)Logger.getMessageLogger(InfinispanLogger.class, (String)"org.jboss.as.clustering.infinispan");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating Infinispan subsystem.")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Started %s cache from %s container")
    public void cacheStarted(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Stopped %s cache from %s container")
    public void cacheStopped(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="The 'eager' attribute specified on the 'transaction' element of a cache is no longer valid")
    public void eagerAttributeDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="The '%s' attribute specified on the 'transport' element of a cache container is no longer valid; use the same attribute specified on the 'transport' element of corresponding JGroups stack instead")
    public void topologyAttributeDeprecated(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=6, value="'%s' cache container installed.")
    public void cacheContainerInstalled(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Attribute 'virtual-nodes' has been deprecated - converting legacy 'virtual-nodes' value to 'segments' value")
    public void virtualNodesAttributeDeprecated();

    @Message(id=8, value="Could not resolve destination address for outbound socket binding named '%s'")
    public InjectionException failedToInjectSocketBinding(@Cause UnknownHostException var1, OutboundSocketBinding var2);

    @Message(id=9, value="Failed to add %s %s cache to non-clustered %s cache container.")
    public StartException transportRequired(CacheMode var1, String var2, String var3);

    @Message(id=10, value="%s is not a valid cache store")
    public OperationFailedException invalidCacheStore(@Cause Throwable var1, String var2);

    @Message(id=11, value="%s is not a valid default cache. The %s cache container does not contain a cache with that name")
    public IllegalArgumentException invalidDefaultCache(String var1, String var2);

    @Message(id=12, value="No %s property was specified within the executor properties: %s")
    public IllegalStateException invalidExecutorProperty(String var1, Properties var2);

    @Message(id=13, value="No %s property was specified within the transport properties: %s")
    public IllegalStateException invalidTransportProperty(String var1, Properties var2);

    @Message(id=14, value="Aborting cache operation after %d retries.")
    public RuntimeException abortingCacheOperation(@Cause Throwable var1, int var2);

    @Message(id=15, value="Invalid value for parameter %s. Allowable values: %s")
    public String invalidParameterValue(String var1, String var2);

    @Message(id=16, value="Cache store cannot be created: cache store %s is already defined")
    public OperationFailedException cacheStoreAlreadyDefined(String var1);

    @Message(id=17, value="Value for property with key %s is not defined")
    public OperationFailedException propertyValueNotDefined(String var1);

    @Message(id=18, value="Failed to locate %s")
    public String notFound(String var1);

    @Message(id=19, value="Failed to parse %s")
    public IllegalStateException failedToParse(@Cause Throwable var1, URL var2);

    @Message(id=20, value="Add operation failed: singleton %s already exists.")
    public OperationFailedException singletonResourceAlreadyExists(String var1);

    @Message(id=21, value="cannot remove alias % from empty list.")
    public OperationFailedException cannotRemoveAliasFromEmptyList(String var1);

    @Message(id=22, value="Attribute '%s' has been deprecated.")
    public OperationFailedException attributeDeprecated(String var1);

    @Message(id=23, value="Attribute 'segments' is an expression and therefore cannot be translated to legacy attribute 'virtual-nodes'. This resource will need to be ignored on that host.")
    public String virtualNodesDoesNotSupportExpressions();

    @Message(id=24, value="Unknown metric %s")
    public String unknownMetric(String var1);

    @Message(id=25, value="Failed to invoke operation: %s")
    public OperationFailedException failedToInvokeOperation(@Cause Throwable var1, String var2);

    @Message(id=26, value="Attribute 'virtual nodes' is an expression and therefore cannot be translated to attribute 'segments'.")
    public String segmentsDoesNotSupportExpressions();
}

