/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.clustering.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class BackupSiteResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement WILDCARD_PATH = BackupSiteResourceDefinition.pathElement("*");
    static final SimpleAttributeDefinition FAILURE_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("failure-policy", ModelType.STRING, true).setXmlName(Attribute.BACKUP_FAILURE_POLICY.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new EnumValidator(BackupFailurePolicy.class, true, true))).setDefaultValue(new ModelNode().set(BackupFailurePolicy.WARN.name()))).build();
    static final SimpleAttributeDefinition STRATEGY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("strategy", ModelType.STRING, true).setXmlName(Attribute.STRATEGY.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new EnumValidator(BackupConfiguration.BackupStrategy.class, true, true))).setDefaultValue(new ModelNode().set(BackupConfiguration.BackupStrategy.ASYNC.name()))).build();
    static final SimpleAttributeDefinition REPLICATION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.STRING, true).setXmlName(Attribute.TIMEOUT.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(10000L))).build();
    static final SimpleAttributeDefinition ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.ENABLED.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(true))).build();
    static final SimpleAttributeDefinition TAKE_OFFLINE_AFTER_FAILURES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("after-failures", ModelType.INT, true).setXmlName(Attribute.TAKE_BACKUP_OFFLINE_AFTER_FAILURES.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(0))).build();
    static final SimpleAttributeDefinition TAKE_OFFLINE_MIN_WAIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("min-wait", ModelType.INT, true).setXmlName(Attribute.TAKE_BACKUP_OFFLINE_MIN_WAIT.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(0))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FAILURE_POLICY, STRATEGY, REPLICATION_TIMEOUT, ENABLED, TAKE_OFFLINE_AFTER_FAILURES, TAKE_OFFLINE_MIN_WAIT};
    static final OperationDefinition BACKUP_BRING_SITE_ONLINE = new SimpleOperationDefinitionBuilder("bring-site-online", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).setRuntimeOnly().build();
    static final OperationDefinition BACKUP_TAKE_SITE_OFFLINE = new SimpleOperationDefinitionBuilder("take-site-offline", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).setRuntimeOnly().build();
    static final OperationDefinition BACKUP_SITE_STATUS = new SimpleOperationDefinitionBuilder("site-status", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).setRuntimeOnly().setReadOnly().build();
    private final boolean runtimeRegistration;

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"backup", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
    }

    BackupSiteResourceDefinition(boolean runtimeRegistration) {
        super(WILDCARD_PATH, InfinispanExtension.getResourceDescriptionResolver("backup"), (OperationStepHandler)new ReloadRequiredAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.runtimeRegistration) {
            resourceRegistration.registerOperationHandler(BACKUP_BRING_SITE_ONLINE, (OperationStepHandler)new BackupBringSiteOnline());
            resourceRegistration.registerOperationHandler(BACKUP_TAKE_SITE_OFFLINE, (OperationStepHandler)new BackupTakeSiteOffline());
            resourceRegistration.registerOperationHandler(BACKUP_SITE_STATUS, (OperationStepHandler)new BackupSiteStatus());
        }
    }

    class BackupSiteStatus
    extends AbstractRuntimeOnlyHandler {
        BackupSiteStatus() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String cacheContainerName = address.getElement(address.size() - 3).getValue();
            String cacheName = address.getElement(address.size() - 2).getValue();
            String site = address.getLastElement().getValue();
            ServiceName cacheServiceName = CacheService.getServiceName(cacheContainerName, cacheName);
            ServiceController controller = context.getServiceRegistry(true).getService(cacheServiceName);
            Cache cache = (Cache)controller.getValue();
            ModelNode result = null;
            try {
                XSiteAdminOperations xSiteAdminOperations = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
                String stringResult = xSiteAdminOperations.siteStatus(site);
                result = new ModelNode().set(stringResult);
            }
            catch (Exception e) {
                throw InfinispanLogger.ROOT_LOGGER.failedToInvokeOperation(e.getCause(), "site-status");
            }
            if (result != null) {
                context.getResult().set(result);
            }
            context.stepCompleted();
        }
    }

    class BackupTakeSiteOffline
    extends AbstractRuntimeOnlyHandler {
        BackupTakeSiteOffline() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String cacheContainerName = address.getElement(address.size() - 3).getValue();
            String cacheName = address.getElement(address.size() - 2).getValue();
            String site = address.getLastElement().getValue();
            ServiceName cacheServiceName = CacheService.getServiceName(cacheContainerName, cacheName);
            ServiceController controller = context.getServiceRegistry(true).getService(cacheServiceName);
            Cache cache = (Cache)controller.getValue();
            ModelNode result = null;
            try {
                XSiteAdminOperations xSiteAdminOperations = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
                String stringResult = xSiteAdminOperations.takeSiteOffline(site);
                result = new ModelNode().set(stringResult);
            }
            catch (Exception e) {
                throw InfinispanLogger.ROOT_LOGGER.failedToInvokeOperation(e.getCause(), "take-site-offline");
            }
            if (result != null) {
                context.getResult().set(result);
            }
            context.stepCompleted();
        }
    }

    class BackupBringSiteOnline
    extends AbstractRuntimeOnlyHandler {
        BackupBringSiteOnline() {
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String cacheContainerName = address.getElement(address.size() - 3).getValue();
            String cacheName = address.getElement(address.size() - 2).getValue();
            String site = address.getLastElement().getValue();
            ServiceName cacheServiceName = CacheService.getServiceName(cacheContainerName, cacheName);
            ServiceController controller = context.getServiceRegistry(true).getService(cacheServiceName);
            Cache cache = (Cache)controller.getValue();
            ModelNode result = null;
            try {
                XSiteAdminOperations xSiteAdminOperations = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
                String stringResult = xSiteAdminOperations.bringSiteOnline(site);
                result = new ModelNode().set(stringResult);
            }
            catch (Exception e) {
                throw InfinispanLogger.ROOT_LOGGER.failedToInvokeOperation(e.getCause(), "bring-site-online");
            }
            if (result != null) {
                context.getResult().set(result);
            }
            context.stepCompleted();
        }
    }
}

