/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;

public class CacheConfigurationService
extends AbstractCacheConfigurationService {
    private final Dependencies dependencies;

    public static ServiceName getServiceName(String container, String cache) {
        return CacheService.getServiceName(container, cache).append(new String[]{"config"});
    }

    public CacheConfigurationService(String name, Dependencies dependencies) {
        super(name);
        this.dependencies = dependencies;
    }

    @Override
    protected EmbeddedCacheManager getCacheContainer() {
        return this.dependencies.getCacheContainer();
    }

    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        TransactionSynchronizationRegistry tsr;
        TransactionManager tm;
        ConfigurationBuilder builder = this.dependencies.getConfigurationBuilder();
        ModuleIdentifier moduleId = this.dependencies.getModuleIdentifier();
        if (moduleId != null) {
            try {
                Module module = this.dependencies.getModuleLoader().loadModule(moduleId);
                ModuleClassLoader loader = module.getClassLoader();
                builder.classLoader((ClassLoader)loader);
                GroupsConfigurationBuilder groupsBuilder = builder.clustering().hash().groups();
                for (Grouper grouper : ServiceLoader.load(Grouper.class, (ClassLoader)loader)) {
                    groupsBuilder.addGrouper(grouper);
                }
            }
            catch (ModuleLoadException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if ((tm = this.dependencies.getTransactionManager()) != null) {
            builder.transaction().transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(tm));
        }
        if ((tsr = this.dependencies.getTransactionSynchronizationRegistry()) != null) {
            builder.transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(tsr));
        }
        boolean topologyAware = this.dependencies.getCacheContainer().getCacheManagerConfiguration().transport().hasTopologyInfo();
        this.dependencies.getConsistentHashStrategy().buildHashConfiguration(builder.clustering().hash(), this.dependencies.getCacheMode(), topologyAware);
        return builder;
    }

    static interface Dependencies {
        public CacheMode getCacheMode();

        public ConfigurationBuilder getConfigurationBuilder();

        public ModuleIdentifier getModuleIdentifier();

        public ModuleLoader getModuleLoader();

        public EmbeddedCacheManager getCacheContainer();

        public TransactionManager getTransactionManager();

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry();

        public ConsistentHashStrategy getConsistentHashStrategy();
    }
}

