/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.CacheContainer;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class CacheContainerMetricsHandler
extends AbstractRuntimeOnlyHandler {
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String containerName = address.getLastElement().getValue();
        String name = operation.require("name").asString();
        CacheContainerMetric metric = CacheContainerMetric.forName(name);
        if (metric == null) {
            context.getFailureDescription().set(InfinispanLogger.ROOT_LOGGER.unknownMetric(name));
        } else {
            CacheContainer container = (CacheContainer)ServiceContainerHelper.findValue((ServiceRegistry)context.getServiceRegistry(false), (ServiceName)EmbeddedCacheManagerService.getServiceName(containerName));
            if (container != null) {
                ModelNode result = metric.getValue(container);
                context.getResult().set(result != null && result.isDefined() ? result : new ModelNode("N/A"));
            }
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

