/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SegmentsAndVirtualNodeConverter;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheAddHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class DistributedCacheAddHandler
extends SharedStateCacheAddHandler {
    static final DistributedCacheAddHandler INSTANCE = new DistributedCacheAddHandler();

    private DistributedCacheAddHandler() {
        super(CacheMode.DIST_SYNC);
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        String deprecatedKey = "virtual-nodes";
        if (operation.hasDefined("virtual-nodes") && operation.get("virtual-nodes").asInt() != 1) {
            InfinispanLogger.ROOT_LOGGER.virtualNodesAttributeDeprecated();
            ModelNode convertedValue = SegmentsAndVirtualNodeConverter.virtualNodesToSegments(operation.get("virtual-nodes"));
            operation.get("segments").set(convertedValue);
            operation.remove("virtual-nodes");
        }
        for (AttributeDefinition attribute : DistributedCacheResourceDefinition.ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode containerModel, ModelNode cache, ConfigurationBuilder builder, CacheAddHandler.CacheConfigurationDependencies cacheConfigurationDependencies, CacheAddHandler.CacheDependencies cacheDependencies, List<CacheAddHandler.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, containerModel, cache, builder, cacheConfigurationDependencies, cacheDependencies, dependencies);
        int owners = DistributedCacheResourceDefinition.OWNERS.resolveModelAttribute(context, cache).asInt();
        int segments = DistributedCacheResourceDefinition.SEGMENTS.resolveModelAttribute(context, cache).asInt();
        long lifespan = DistributedCacheResourceDefinition.L1_LIFESPAN.resolveModelAttribute(context, cache).asLong();
        Double capacityFactor = DistributedCacheResourceDefinition.CAPACITY_FACTOR.resolveModelAttribute(context, cache).asDouble();
        ConsistentHashStrategy strategy = ConsistentHashStrategy.valueOf(DistributedCacheResourceDefinition.CONSISTENT_HASH_STRATEGY.resolveModelAttribute(context, cache).asString());
        cacheConfigurationDependencies.setConsistentHashStrategy(strategy);
        builder.clustering().hash().numOwners(owners).numSegments(segments).capacityFactor(capacityFactor.floatValue());
        if (lifespan > 0L) {
            builder.clustering().l1().lifespan(lifespan);
        } else {
            builder.clustering().l1().disable();
        }
    }
}

