/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class StoreAddHandler
extends AbstractAddStepHandler {
    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        if (StoreAddHandler.isCacheStoreDefined(context, operation)) {
            String storeName = StoreAddHandler.getDefinedCacheStore(context, operation);
            throw InfinispanLogger.ROOT_LOGGER.cacheStoreAlreadyDefined(storeName);
        }
        for (AttributeDefinition attribute : StoreResourceDefinition.PARAMETERS) {
            if (attribute.getName().equals(StoreResourceDefinition.PROPERTIES.getName())) continue;
            attribute.validateAndSet(operation, model);
        }
        if (operation.hasDefined("properties")) {
            for (Property property : operation.get("properties").asPropertyList()) {
                Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                ModelNode value = property.getValue();
                if (!value.isDefined()) {
                    throw InfinispanLogger.ROOT_LOGGER.propertyValueNotDefined(property.getName());
                }
                StorePropertyResourceDefinition.VALUE.validateAndSet(value, param.getModel());
            }
        }
    }

    private static boolean isCacheStoreDefined(OperationContext context, ModelNode operation) {
        ModelNode cache = StoreAddHandler.getCache(context, StoreAddHandler.getCacheAddress(operation));
        return StoreAddHandler.hasCustomStore(cache) || StoreAddHandler.hasFileStore(cache) || StoreAddHandler.hasStringKeyedJdbcStore(cache) || StoreAddHandler.hasBinaryKeyedJdbcStore(cache) || StoreAddHandler.hasMixedKeyedJdbcStore(cache) || StoreAddHandler.hasRemoteStore(cache);
    }

    private static String getDefinedCacheStore(OperationContext context, ModelNode operation) {
        ModelNode cache = StoreAddHandler.getCache(context, StoreAddHandler.getCacheAddress(operation));
        if (StoreAddHandler.hasCustomStore(cache)) {
            return "store";
        }
        if (StoreAddHandler.hasFileStore(cache)) {
            return "file-store";
        }
        if (StoreAddHandler.hasStringKeyedJdbcStore(cache)) {
            return "string-keyed-jdbc-store";
        }
        if (StoreAddHandler.hasBinaryKeyedJdbcStore(cache)) {
            return "binary-keyed-jdbc-store";
        }
        if (StoreAddHandler.hasMixedKeyedJdbcStore(cache)) {
            return "mixed-keyed-jdbc-store";
        }
        if (StoreAddHandler.hasRemoteStore(cache)) {
            return "remote-store";
        }
        return null;
    }

    private static PathAddress getCacheAddress(ModelNode operation) {
        PathAddress cacheStoreAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress cacheAddress = cacheStoreAddress.subAddress(0, cacheStoreAddress.size() - 1);
        return cacheAddress;
    }

    private static ModelNode getCache(OperationContext context, PathAddress cacheAddress) {
        ModelNode cache = Resource.Tools.readModel((Resource)context.readResourceFromRoot(cacheAddress));
        return cache;
    }

    private static boolean hasCustomStore(ModelNode cache) {
        return cache.hasDefined("store") && cache.get(new String[]{"store", "STORE"}).isDefined();
    }

    private static boolean hasFileStore(ModelNode cache) {
        return cache.hasDefined("file-store") && cache.get(new String[]{"file-store", "FILE_STORE"}).isDefined();
    }

    private static boolean hasStringKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("string-keyed-jdbc-store") && cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasBinaryKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("binary-keyed-jdbc-store") && cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasMixedKeyedJdbcStore(ModelNode cache) {
        return cache.hasDefined("mixed-keyed-jdbc-store") && cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"}).isDefined();
    }

    private static boolean hasRemoteStore(ModelNode cache) {
        return cache.hasDefined("remote-store") && cache.get(new String[]{"remote-store", "REMOTE_STORE"}).isDefined();
    }
}

