/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.controller.AttributeOperationTransformer;
import org.jboss.as.clustering.controller.ChainedOperationTransformer;
import org.jboss.as.clustering.controller.OperationFactory;
import org.jboss.as.clustering.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMetric;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransactionResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH = PathElement.pathElement((String)"transaction", (String)"TRANSACTION");
    static final SimpleAttributeDefinition LOCKING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("locking", ModelType.STRING, true).setXmlName(Attribute.LOCKING.getLocalName())).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(LockingMode.class, true, false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(LockingMode.PESSIMISTIC.name()))).build();
    static final SimpleAttributeDefinition MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mode", ModelType.STRING, true).setXmlName(Attribute.MODE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new EnumValidator(TransactionMode.class, true, true))).setDefaultValue(new ModelNode().set(TransactionMode.NONE.name()))).build();
    static final SimpleAttributeDefinition STOP_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("stop-timeout", ModelType.LONG, true).setXmlName(Attribute.STOP_TIMEOUT.getLocalName())).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(30000))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MODE, STOP_TIMEOUT, LOCKING};
    private final boolean allowRuntimeOnlyRegistration;

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(PATH);
        LinkedList<OperationTransformer> addOperationTransformers = new LinkedList<OperationTransformer>();
        LinkedList<OperationTransformer> removeOperationTransformers = new LinkedList<OperationTransformer>();
        HashMap<String, OperationTransformer> readAttributeTransformers = new HashMap<String, OperationTransformer>();
        HashMap<String, OperationTransformer> writeAttributeTransformers = new HashMap<String, OperationTransformer>();
        HashMap<String, OperationTransformer> undefineAttributeTransformers = new HashMap<String, OperationTransformer>();
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            OperationTransformer addTransformer = new OperationTransformer(){

                public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                    if (operation.hasDefined(MODE.getName())) {
                        boolean batching;
                        ModelNode mode = operation.get(MODE.getName());
                        boolean bl = batching = TransactionMode.valueOf(mode.asString()) == TransactionMode.BATCH;
                        if (batching) {
                            mode.set(TransactionMode.NONE.name());
                            ModelNode writeBatchingOperation = OperationFactory.createWriteAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName(), (ModelNode)new ModelNode(true));
                            return new OperationTransformer.TransformedOperation(OperationFactory.createCompositeOperation((ModelNode[])new ModelNode[]{writeBatchingOperation, operation}), OperationResultTransformer.ORIGINAL_RESULT);
                        }
                    }
                    return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
                }
            };
            addOperationTransformers.add(addTransformer);
            OperationTransformer removeTransformer = new OperationTransformer(){

                public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                    ModelNode undefineBatchingOperation = OperationFactory.createUndefineAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName());
                    return new OperationTransformer.TransformedOperation(OperationFactory.createCompositeOperation((ModelNode[])new ModelNode[]{undefineBatchingOperation, operation}), OperationResultTransformer.ORIGINAL_RESULT);
                }
            };
            removeOperationTransformers.add(removeTransformer);
            OperationTransformer readAttributeTransformer = new OperationTransformer(){

                public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                    ModelNode readBatchingOperation = OperationFactory.createReadAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName());
                    OperationResultTransformer resultTransformer = new OperationResultTransformer(){

                        public ModelNode transformResult(ModelNode result) {
                            ModelNode readBatchingResult = result.get(0);
                            return readBatchingResult.asBoolean() ? new ModelNode(TransactionMode.BATCH.name()) : result.get(1);
                        }
                    };
                    return new OperationTransformer.TransformedOperation(OperationFactory.createCompositeOperation((ModelNode[])new ModelNode[]{readBatchingOperation, operation}), resultTransformer);
                }
            };
            readAttributeTransformers.put(MODE.getName(), readAttributeTransformer);
            OperationTransformer writeAttributeTransformer = new OperationTransformer(){

                public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                    boolean batching;
                    ModelNode mode;
                    ModelNode modelNode = mode = operation.hasDefined("value") ? operation.get("value") : null;
                    boolean bl = mode != null ? TransactionMode.valueOf(mode.asString()) == TransactionMode.BATCH : (batching = false);
                    if (batching) {
                        mode.set(TransactionMode.NONE.name());
                    }
                    ModelNode writeBatchingOperation = OperationFactory.createWriteAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName(), (ModelNode)new ModelNode(batching));
                    return new OperationTransformer.TransformedOperation(OperationFactory.createCompositeOperation((ModelNode[])new ModelNode[]{writeBatchingOperation, operation}), OperationResultTransformer.ORIGINAL_RESULT);
                }
            };
            writeAttributeTransformers.put(MODE.getName(), writeAttributeTransformer);
            undefineAttributeTransformers.put(MODE.getName(), writeAttributeTransformer);
            AttributeConverter modeConverter = new AttributeConverter(){

                public void convertOperationParameter(PathAddress address, String name, ModelNode value, ModelNode operation, TransformationContext context) {
                }

                public void convertResourceAttribute(PathAddress address, String name, ModelNode value, TransformationContext context) {
                    TransactionMode mode;
                    if (value.isDefined() && (mode = TransactionMode.valueOf(value.asString())) == TransactionMode.BATCH) {
                        value.set(TransactionMode.NONE.name());
                    }
                }
            };
            builder.getAttributeBuilder().setValueConverter(modeConverter, new AttributeDefinition[]{MODE});
        }
        if (InfinispanModel.VERSION_1_4_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{MODE, STOP_TIMEOUT, LOCKING});
        }
        TransactionResourceDefinition.buildOperationTransformation(builder, "add", addOperationTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "remove", removeOperationTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "read-attribute", readAttributeTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "write-attribute", writeAttributeTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "undefine-attribute", undefineAttributeTransformers);
    }

    static void buildOperationTransformation(ResourceTransformationDescriptionBuilder builder, String operationName, List<OperationTransformer> transformers) {
        if (!transformers.isEmpty()) {
            builder.addOperationTransformationOverride(operationName).setCustomOperationTransformer((OperationTransformer)new ChainedOperationTransformer(transformers)).inheritResourceAttributeDefinitions();
        }
    }

    static void buildOperationTransformation(ResourceTransformationDescriptionBuilder builder, String operationName, Map<String, OperationTransformer> transformers) {
        if (!transformers.isEmpty()) {
            builder.addOperationTransformationOverride(operationName).setCustomOperationTransformer((OperationTransformer)new AttributeOperationTransformer(transformers)).inheritResourceAttributeDefinitions();
        }
    }

    static PathAddress cacheAddress(PathAddress transactionAddress) {
        return transactionAddress.subAddress(0, transactionAddress.size() - 1);
    }

    TransactionResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(PATH, InfinispanExtension.getResourceDescriptionResolver("transaction"), (OperationStepHandler)new ReloadRequiredAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
        if (this.allowRuntimeOnlyRegistration) {
            TransactionMetricsHandler handler = new TransactionMetricsHandler();
            for (TransactionMetric metric : TransactionMetric.values()) {
                registration.registerMetric(metric.getDefinition(), (OperationStepHandler)handler);
            }
        }
    }
}

