/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.wildfly.extension.io.WorkerService;
import org.wildfly.extension.io.logging.IOLogger;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

class WorkerAdd
extends AbstractAddStepHandler {
    static final WorkerAdd INSTANCE = new WorkerAdd();

    private WorkerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (OptionAttributeDefinition attr : WorkerResourceDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    private static int getMaxDescriptorCount() {
        try {
            ObjectName oName = new ObjectName("java.lang:type=OperatingSystem");
            MBeanServer conn = ManagementFactory.getPlatformMBeanServer();
            Object maxResult = conn.getAttribute(oName, "MaxFileDescriptorCount");
            if (maxResult != null) {
                IOLogger.ROOT_LOGGER.tracef("System has MaxFileDescriptorCount set to %d", maxResult);
                return ((Long)maxResult).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        IOLogger.ROOT_LOGGER.tracef("We cannot get MaxFileDescriptorCount from system, not applying any limits", new Object[0]);
        return -1;
    }

    private static int getCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static int getMaxPossibleThreadCount(int maxFD) {
        return (maxFD - 600) / 3;
    }

    private static int getSuggestedTaskCount() {
        return WorkerAdd.getCpuCount() * 16;
    }

    private static int getSuggestedIoThreadCount() {
        return WorkerAdd.getCpuCount() * 2;
    }

    private static int getWorkerThreads(String workerName, int totalWorkerCount) {
        int suggestedCount;
        int count = suggestedCount = WorkerAdd.getSuggestedTaskCount();
        int maxFD = WorkerAdd.getMaxDescriptorCount();
        if (maxFD > -1) {
            int maxPossible = WorkerAdd.getMaxPossibleThreadCount(maxFD);
            if ((maxPossible /= totalWorkerCount) < 5) {
                count = 5;
            } else if (maxPossible < suggestedCount) {
                count = maxPossible;
                IOLogger.ROOT_LOGGER.lowFD(workerName, suggestedCount, WorkerAdd.getCpuCount());
            }
        }
        return count;
    }

    private static int getGlobalSuggestedCount(OperationContext context, ModelNode workers) throws OperationFailedException {
        int count = 0;
        for (Property property : workers.asPropertyList()) {
            ModelNode worker = property.getValue();
            ModelNode ioThreadsModel = WorkerResourceDefinition.WORKER_IO_THREADS.resolveModelAttribute(context, worker);
            ModelNode maxTaskThreadsModel = WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.resolveModelAttribute(context, worker);
            count = ioThreadsModel.isDefined() ? (count += ioThreadsModel.asInt()) : (count += WorkerAdd.getSuggestedIoThreadCount());
            if (maxTaskThreadsModel.isDefined()) {
                count += maxTaskThreadsModel.asInt();
                continue;
            }
            count += WorkerAdd.getSuggestedTaskCount();
        }
        return count;
    }

    static void checkWorkerConfiguration(OperationContext context, ModelNode workers) throws OperationFailedException {
        IOLogger.ROOT_LOGGER.trace("Checking worker configuration");
        int requiredCount = WorkerAdd.getGlobalSuggestedCount(context, workers);
        IOLogger.ROOT_LOGGER.tracef("Global required thread count is: %d", requiredCount);
        int requiredFDCount = requiredCount * 3 + 600;
        IOLogger.ROOT_LOGGER.tracef("Global required FD count is: %d", requiredFDCount);
        int maxFd = WorkerAdd.getMaxDescriptorCount();
        if (maxFd > -1 && maxFd < requiredFDCount) {
            IOLogger.ROOT_LOGGER.lowGlobalFD(maxFd, requiredFDCount);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        Resource resource = context.readResourceFromRoot(address.subAddress(0, address.size() - 1));
        ModelNode workers = Resource.Tools.readModel((Resource)resource).get(IOExtension.WORKER_PATH.getKey());
        int allWorkerCount = workers.asList().size();
        String name = address.getLastElement().getValue();
        OptionMap.Builder builder = OptionMap.builder();
        for (OptionAttributeDefinition attr : WorkerResourceDefinition.ATTRIBUTES) {
            Option<?> option = attr.getOption();
            ModelNode value = attr.resolveModelAttribute(context, model);
            if (!value.isDefined()) continue;
            if (attr.getType() == ModelType.INT) {
                builder.set(option, value.asInt());
                continue;
            }
            if (attr.getType() == ModelType.LONG) {
                builder.set(option, value.asLong());
                continue;
            }
            if (attr.getType() != ModelType.BOOLEAN) continue;
            builder.set(option, value.asBoolean());
        }
        builder.set(Options.WORKER_NAME, (Object)name);
        ModelNode ioThreadsModel = WorkerResourceDefinition.WORKER_IO_THREADS.resolveModelAttribute(context, model);
        ModelNode maxTaskThreadsModel = WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.resolveModelAttribute(context, model);
        int cpuCount = WorkerAdd.getCpuCount();
        int ioThreadsCalculated = WorkerAdd.getSuggestedIoThreadCount();
        if (!ioThreadsModel.isDefined() && !maxTaskThreadsModel.isDefined()) {
            int workerThreads = WorkerAdd.getWorkerThreads(name, allWorkerCount);
            builder.set(WorkerResourceDefinition.WORKER_IO_THREADS.getOption(), ioThreadsCalculated);
            builder.set(WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.getOption(), workerThreads);
            IOLogger.ROOT_LOGGER.printDefaults(name, ioThreadsCalculated, workerThreads, cpuCount);
        } else {
            if (!ioThreadsModel.isDefined()) {
                builder.set(WorkerResourceDefinition.WORKER_IO_THREADS.getOption(), ioThreadsCalculated);
                IOLogger.ROOT_LOGGER.printDefaultsIoThreads(name, ioThreadsCalculated, cpuCount);
            }
            if (!maxTaskThreadsModel.isDefined()) {
                int workerThreads = WorkerAdd.getWorkerThreads(name, allWorkerCount);
                builder.set(WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.getOption(), workerThreads);
                IOLogger.ROOT_LOGGER.printDefaultsWorkerThreads(name, workerThreads, cpuCount);
            }
        }
        WorkerService workerService = new WorkerService(builder.getMap());
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(IOServices.WORKER.append(new String[]{name}), (Service)workerService);
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        ServiceController serviceController = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
    }
}

