/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetric;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetricsHandler;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolMetricsHandler;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;

public class ChannelInstanceResourceDefinition
extends SimpleResourceDefinition {
    private final boolean runtimeRegistration;

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"channel", (String)name);
    }

    ChannelInstanceResourceDefinition(String channelName, boolean runtimeRegistration) {
        super(ChannelInstanceResourceDefinition.pathElement(channelName), JGroupsExtension.getResourceDescriptionResolver("channel"), null, null);
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        if (this.runtimeRegistration) {
            ChannelMetricsHandler handler = new ChannelMetricsHandler();
            for (ChannelMetric metric : ChannelMetric.values()) {
                registration.registerMetric(metric.getDefinition(), (OperationStepHandler)handler);
            }
        }
    }

    public static void addChannelProtocolMetricsRegistrationStep(OperationContext context, String channelName, String stackName) {
        PathAddress rootSubsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        ModelNode registerProtocolsOp = Util.createOperation((String)"some_operation_name", (PathAddress)rootSubsystemAddress);
        if (stackName != null) {
            registerProtocolsOp.get("stack").set(new ModelNode(stackName));
        }
        registerProtocolsOp.get("channel").set(new ModelNode(channelName));
        context.addStep(registerProtocolsOp, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String channelName = operation.get("channel").asString();
                String stackName = null;
                if (operation.get("stack").isDefined()) {
                    stackName = operation.get("stack").asString();
                }
                ChannelInstanceResourceDefinition.registerChannelProtocolMetrics(context, channelName, stackName);
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
    }

    public static void registerChannelProtocolMetrics(OperationContext context, String channelName, String stackName) throws OperationFailedException {
        if (stackName == null) {
            stackName = ChannelInstanceResourceDefinition.getDefaultStack(context);
        }
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        PathAddress stackAddress = address.append(new PathElement[]{StackResourceDefinition.pathElement(stackName)});
        ModelNode stack = Resource.Tools.readModel((Resource)context.readResourceFromRoot(stackAddress, true));
        ModelNode transport = stack.get(new String[]{"transport", "TRANSPORT"}).clone();
        String transportName = TransportResourceDefinition.TYPE.resolveModelAttribute(context, transport).asString();
        ResourceDefinition transportDefinition = ChannelInstanceResourceDefinition.getProtocolMetricResourceDefinition(context, channelName, transportName);
        List protocolOrdering = stack.get("protocols").clone().asList();
        ArrayList<ResourceDefinition> protocolDefinitions = new ArrayList<ResourceDefinition>();
        for (ModelNode protocolNameModelNode : protocolOrdering) {
            String protocolName = protocolNameModelNode.asString();
            ResourceDefinition protocolDefinition = ChannelInstanceResourceDefinition.getProtocolMetricResourceDefinition(context, channelName, protocolName);
            protocolDefinitions.add(protocolDefinition);
        }
        ResourceDefinition relayDefinition = null;
        if (stack.hasDefined("relay")) {
            relayDefinition = ChannelInstanceResourceDefinition.getProtocolMetricResourceDefinition(context, channelName, "relay.RELAY2");
        }
        ManagementResourceRegistration subsystemRootRegistration = context.getResourceRegistrationForUpdate();
        ManagementResourceRegistration channelRegistration = subsystemRootRegistration.registerSubModel((ResourceDefinition)new ChannelInstanceResourceDefinition(channelName, true));
        channelRegistration.registerSubModel(transportDefinition);
        for (ResourceDefinition protocolDefinition : protocolDefinitions) {
            channelRegistration.registerSubModel(protocolDefinition);
        }
        if (stack.hasDefined("relay")) {
            channelRegistration.registerSubModel(relayDefinition);
        }
    }

    public static void addChannelProtocolMetricsDeregistrationStep(OperationContext context, String channelName) {
    }

    private static String getDefaultStack(OperationContext context) throws OperationFailedException {
        ModelNode resolvedValue = null;
        PathAddress subsystemPath = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        ModelNode subsystem = Resource.Tools.readModel((Resource)context.readResourceFromRoot(subsystemPath));
        resolvedValue = JGroupsSubsystemResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, subsystem);
        return resolvedValue.isDefined() ? resolvedValue.asString() : null;
    }

    private static ResourceDefinition getProtocolMetricResourceDefinition(OperationContext context, String channelName, String protocolName) throws OperationFailedException {
        ManagedAttribute managed;
        String className = "org.jgroups.protocols." + protocolName;
        Class<Protocol> protocolClass = null;
        try {
            protocolClass = Protocol.class.getClassLoader().loadClass(className).asSubclass(Protocol.class);
        }
        catch (Exception e) {
            throw JGroupsLogger.ROOT_LOGGER.unableToLoadProtocolClass(className);
        }
        Field[] fields = ChannelInstanceResourceDefinition.getProtocolFields(protocolClass);
        HashMap<String, AttributeDefinition> attributesByField = new HashMap<String, AttributeDefinition>();
        HashMap<String, String> attributeDescriptionMap = new HashMap<String, String>();
        attributeDescriptionMap.put(protocolName, "The " + protocolName + " protocol");
        for (Field field : fields) {
            boolean equivalentTypeAvailable = ChannelInstanceResourceDefinition.isEquivalentModelTypeAvailable(field.getType());
            managed = field.getAnnotation(ManagedAttribute.class);
            if (managed != null) {
                ChannelInstanceResourceDefinition.addAttributeDefinition(attributesByField, attributeDescriptionMap, protocolName, field.getName(), equivalentTypeAvailable ? ChannelInstanceResourceDefinition.getEquivalentModelType(field.getType()) : ModelType.STRING, managed.description());
                continue;
            }
            Property property = field.getAnnotation(Property.class);
            if (property == null) continue;
            ChannelInstanceResourceDefinition.addAttributeDefinition(attributesByField, attributeDescriptionMap, protocolName, field.getName(), equivalentTypeAvailable ? ChannelInstanceResourceDefinition.getEquivalentModelType(field.getType()) : ModelType.STRING, property.description());
        }
        HashMap<String, AttributeDefinition> attributesByMethod = new HashMap<String, AttributeDefinition>();
        for (Method method : ChannelInstanceResourceDefinition.getProtocolMethods(protocolClass)) {
            managed = method.getAnnotation(ManagedAttribute.class);
            if (managed == null || attributesByField.containsKey(method.getName())) continue;
            boolean equivalentTypeAvailable = ChannelInstanceResourceDefinition.isEquivalentModelTypeAvailable(method.getReturnType());
            ChannelInstanceResourceDefinition.addAttributeDefinition(attributesByMethod, attributeDescriptionMap, protocolName, method.getName(), equivalentTypeAvailable ? ChannelInstanceResourceDefinition.getEquivalentModelType(method.getReturnType()) : ModelType.STRING, managed.description());
        }
        ResourceBuilder protocolBuilder = ResourceBuilder.Factory.create((PathElement)PathElement.pathElement((String)"protocol", (String)protocolName), (StandardResourceDescriptionResolver)new StandardResourceDescriptionResolver(protocolName, "org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResourceDefinition$ProtocolResources", ChannelInstanceResourceDefinition.class.getClassLoader()));
        for (AttributeDefinition def : attributesByField.values()) {
            protocolBuilder.addMetric(def, (OperationStepHandler)new ProtocolMetricsHandler(true));
        }
        for (AttributeDefinition def : attributesByMethod.values()) {
            protocolBuilder.addMetric(def, (OperationStepHandler)new ProtocolMetricsHandler(false));
        }
        ProtocolResources.addProtocolMapEntries(attributeDescriptionMap);
        return protocolBuilder.build();
    }

    private static void addAttributeDefinition(Map<String, AttributeDefinition> attributes, Map<String, String> map, String protocolName, String name, ModelType type, String description) {
        SimpleAttributeDefinitionBuilder builder = new SimpleAttributeDefinitionBuilder(name, type, true);
        builder.setStorageRuntime();
        attributes.put(name, (AttributeDefinition)builder.build());
        map.put(protocolName + "." + name, description);
    }

    public static boolean isEquivalentModelTypeAvailable(Class<?> type) {
        String[] equivalentTypes = new String[]{"int", "short", "long", "float", "double", "boolean", "class java.lang.String"};
        boolean available = false;
        for (String equivalentType : equivalentTypes) {
            if (!type.toString().equals(equivalentType)) continue;
            available = true;
            break;
        }
        return available;
    }

    private static ModelType getEquivalentModelType(Class<?> typeClass) {
        ProtocolMetricsHandler.FieldTypes type = ProtocolMetricsHandler.FieldTypes.getStat(typeClass.toString());
        switch (type) {
            case BOOLEAN: {
                return ModelType.BOOLEAN;
            }
            case BYTE: {
                return ModelType.UNDEFINED;
            }
            case CHAR: {
                return ModelType.UNDEFINED;
            }
            case SHORT: {
                return ModelType.INT;
            }
            case INT: {
                return ModelType.INT;
            }
            case LONG: {
                return ModelType.LONG;
            }
            case FLOAT: {
                return ModelType.DOUBLE;
            }
            case DOUBLE: {
                return ModelType.DOUBLE;
            }
            case STRING: {
                return ModelType.STRING;
            }
        }
        return ModelType.UNDEFINED;
    }

    private static Field[] getProtocolFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            fields.addAll(Arrays.asList(ChannelInstanceResourceDefinition.getProtocolFields(clazz.getSuperclass())));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private static Method[] getProtocolMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getParameterTypes().length != 0) continue;
            methods.add(m);
        }
        if (clazz.getSuperclass() != null) {
            methods.addAll(Arrays.asList(ChannelInstanceResourceDefinition.getProtocolMethods(clazz.getSuperclass())));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    public static class ProtocolResources
    extends ResourceBundle {
        private static Map<String, String> resources = new HashMap<String, String>();

        public static void addProtocolMapEntries(Map<String, String> map) {
            resources.putAll(map);
        }

        @Override
        public Object handleGetObject(String key) {
            return resources.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.keySet());
        }

        @Override
        protected Set<String> handleKeySet() {
            return resources.keySet();
        }
    }
}

