/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetric;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.JChannel;

public class ChannelMetricsHandler
extends AbstractRuntimeOnlyHandler {
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String channelName = pathAddress.getLastElement().getValue();
        String name = operation.require("name").asString();
        ChannelMetric metric = ChannelMetric.forName(name);
        if (metric == null) {
            context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.unknownMetric(name));
        } else {
            JChannel channel = (JChannel)ServiceContainerHelper.findValue((ServiceRegistry)context.getServiceRegistry(false), (ServiceName)ChannelService.getServiceName(channelName));
            if (channel != null) {
                context.getResult().set(metric.getValue(channel));
            }
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

