/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import javax.management.MBeanServer;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;

public class ChannelService
implements Service<Channel>,
ChannelListener {
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jgroups"}).append(new String[]{"channel"});
    private final InjectedValue<MBeanServer> server = new InjectedValue();
    private final InjectedValue<ChannelFactory> factory = new InjectedValue();
    private final String id;
    private volatile Channel channel;

    public static ServiceName getServiceName(String id) {
        return SERVICE_NAME.append(new String[]{id});
    }

    public static ServiceBuilder<Channel> build(ServiceTarget target, String id, String stack) {
        ChannelService service = new ChannelService(id);
        return target.addService(ChannelService.getServiceName(id), (Service)service).addDependency(ChannelFactoryService.getServiceName(stack), ChannelFactory.class, service.factory).addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.server);
    }

    private ChannelService(String id) {
        this.id = id;
    }

    public Channel getValue() {
        return this.channel;
    }

    public void start(StartContext context) throws StartException {
        ChannelFactory factory = (ChannelFactory)this.factory.getValue();
        try {
            this.channel = factory.createChannel(this.id);
            this.channel.addChannelListener((ChannelListener)this);
            JmxConfigurator.registerChannel((JChannel)((JChannel)this.channel), (MBeanServer)((MBeanServer)this.server.getValue()), (String)this.id);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        if (JGroupsLogger.ROOT_LOGGER.isTraceEnabled()) {
            String output = this.channel.getProtocolStack().printProtocolSpec(true);
            JGroupsLogger.ROOT_LOGGER.tracef("JGroups channel %s created with configuration:\n %s", this.id, output);
        }
    }

    public void stop(StopContext context) {
        if (this.channel != null) {
            this.channel.removeChannelListener((ChannelListener)this);
            this.channel.close();
            try {
                JmxConfigurator.unregisterChannel((JChannel)((JChannel)this.channel), (MBeanServer)((MBeanServer)this.server.getValue()), (String)this.id);
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.debug(e.getMessage(), e);
            }
        }
        this.channel = null;
    }

    public void channelClosed(Channel channel) {
    }

    public void channelConnected(Channel channel) {
        String localName = channel.getName();
        Address localAddress = channel.getAddress();
        for (Address address : channel.getView()) {
            String name = channel.getName(address);
            if (name == null || !name.equals(localName) || address.equals(localAddress)) continue;
            channel.close();
            throw JGroupsLogger.ROOT_LOGGER.duplicateNodeName(((ChannelFactory)this.factory.getValue()).getProtocolStackConfiguration().getEnvironment().getNodeName());
        }
    }

    public void channelDisconnected(Channel channel) {
    }
}

