/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import org.jboss.as.clustering.jgroups.LogFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemDescribeHandler;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLReader;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLWriter;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JGroupsExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jgroups";
    private static final String RESOURCE_NAME = JGroupsExtension.class.getPackage().getName() + ".LocalDescriptions";

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JGroupsExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ModelVersion current = JGroupsModel.CURRENT.getVersion();
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, current.getMajor(), current.getMinor(), current.getMicro());
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel((ResourceDefinition)new JGroupsSubsystemResourceDefinition(context.isRuntimeOnlyRegistrationValid()));
        subsystem.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)new JGroupsSubsystemDescribeHandler());
        registration.registerXMLElementWriter((XMLElementWriter)new JGroupsSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            for (JGroupsModel model : EnumSet.complementOf(EnumSet.of(JGroupsModel.CURRENT))) {
                ModelVersion version = model.getVersion();
                TransformationDescription.Tools.register((TransformationDescription)JGroupsSubsystemResourceDefinition.buildTransformers(version), (SubsystemRegistration)registration, (ModelVersionRange)version);
            }
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (JGroupsSchema schema : JGroupsSchema.values()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new JGroupsSubsystemXMLReader(schema));
        }
    }

    static {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("jgroups.logging.log_factory_class") == null) {
                    System.setProperty("jgroups.logging.log_factory_class", LogFactory.class.getName());
                }
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }
}

