/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResource;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class JGroupsSubsystemAddHandler
extends AbstractAddStepHandler {
    protected Resource createResource(OperationContext context) {
        assert (context.getServiceRegistry(false) != null);
        JGroupsSubsystemResource resource = new JGroupsSubsystemResource();
        resource.setRegistry(context.getServiceRegistry(false));
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        return resource;
    }

    JGroupsSubsystemAddHandler(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem();
        ServiceTarget target = context.getServiceTarget();
        ServiceController<ProtocolDefaults> pdsController = this.installProtocolDefaultsService(target, verificationHandler);
        if (newControllers != null) {
            newControllers.add(pdsController);
        }
        String stack = JGroupsSubsystemResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, model).asString();
        ServiceController<ChannelFactory> dcfsController = this.installDefaultChannelFactoryService(target, stack, verificationHandler);
        if (newControllers != null) {
            newControllers.add(dcfsController);
        }
    }

    protected ServiceController<ProtocolDefaults> installProtocolDefaultsService(ServiceTarget target, ServiceVerificationHandler verificationHandler) {
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)ProtocolDefaultsService.SERVICE_NAME, (Service)new ProtocolDefaultsService()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected ServiceController<ChannelFactory> installDefaultChannelFactoryService(ServiceTarget target, String stack, ServiceVerificationHandler verificationHandler) {
        InjectedValue factory = new InjectedValue();
        return target.addService(ChannelFactoryService.getServiceName(null), (Service)new ValueService((Value)factory)).addDependency(ChannelFactoryService.getServiceName(stack), ChannelFactory.class, (Injector)factory).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

