/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackAddHandler;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class JGroupsSubsystemDescribeHandler
implements OperationStepHandler {
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = new ModelNode();
        PathAddress opAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        AuthorizationResult authResult = context.authorize(operation, GenericSubsystemDescribeHandler.DESCRIBE_EFFECTS);
        if (authResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), opAddress, authResult.getExplanation());
        }
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{opAddress.getLastElement()});
        ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        result.add(JGroupsSubsystemDescribeHandler.createOperation(rootAddress, model, JGroupsSubsystemResourceDefinition.ATTRIBUTES));
        if (model.hasDefined(StackResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : model.get(StackResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                PathAddress stackAddress = rootAddress.append(new PathElement[]{StackResourceDefinition.pathElement(property.getName())});
                ModelNode stack = property.getValue();
                result.add(JGroupsSubsystemDescribeHandler.createOperation(stackAddress, stack, new AttributeDefinition[0]));
                if (stack.get(TransportResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
                    ModelNode transport = stack.get(TransportResourceDefinition.PATH.getKeyValuePair());
                    PathAddress transportAddress = stackAddress.append(new PathElement[]{TransportResourceDefinition.PATH});
                    result.add(JGroupsSubsystemDescribeHandler.createOperation(transportAddress, transport, TransportResourceDefinition.ATTRIBUTES));
                    JGroupsSubsystemDescribeHandler.addProtocolPropertyCommands(transportAddress, transport, result);
                }
                if (stack.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).isDefined()) {
                    for (Property protocol : StackAddHandler.getOrderedProtocolPropertyList(stack)) {
                        result.add(JGroupsSubsystemDescribeHandler.createProtocolOperation(stackAddress, protocol.getValue(), ProtocolResourceDefinition.ATTRIBUTES));
                        PathAddress protocolAddress = stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement(protocol.getName())});
                        JGroupsSubsystemDescribeHandler.addProtocolPropertyCommands(protocolAddress, protocol.getValue(), result);
                    }
                }
                if (!stack.get(RelayResourceDefinition.PATH.getKeyValuePair()).isDefined()) continue;
                ModelNode relay = stack.get(RelayResourceDefinition.PATH.getKeyValuePair());
                PathAddress relayAddress = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
                result.add(JGroupsSubsystemDescribeHandler.createOperation(relayAddress, relay, RelayResourceDefinition.ATTRIBUTES));
                JGroupsSubsystemDescribeHandler.addProtocolPropertyCommands(relayAddress, relay, result);
                if (!relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).isDefined()) continue;
                for (Property remoteSite : relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    PathAddress remoteSiteAddress = relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.pathElement(remoteSite.getName())});
                    result.add(JGroupsSubsystemDescribeHandler.createOperation(remoteSiteAddress, remoteSite.getValue(), RemoteSiteResourceDefinition.ATTRIBUTES));
                }
            }
        }
        context.getResult().set(result);
        context.stepCompleted();
    }

    private static void addProtocolPropertyCommands(PathAddress address, ModelNode protocol, ModelNode result) throws OperationFailedException {
        if (protocol.hasDefined(PropertyResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : protocol.get(PropertyResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                PathAddress propertyAddress = address.append(new PathElement[]{PropertyResourceDefinition.pathElement(property.getName())});
                result.add(JGroupsSubsystemDescribeHandler.createOperation(propertyAddress, property.getValue(), new AttributeDefinition[]{PropertyResourceDefinition.VALUE}));
            }
        }
    }

    private static ModelNode createOperation(PathAddress address, ModelNode existing, AttributeDefinition ... attributes) throws OperationFailedException {
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }

    private static ModelNode createProtocolOperation(PathAddress address, ModelNode existing, AttributeDefinition ... attributes) throws OperationFailedException {
        ModelNode operation = Util.createOperation((String)"add-protocol", (PathAddress)address);
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(existing, operation);
        }
        return operation;
    }
}

