/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.clustering.jgroups.subsystem.StackRemoveHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceName;

public class JGroupsSubsystemRemoveHandler
extends AbstractRemoveStepHandler {
    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress opAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ModelNode removeSubsystem = Util.createOperation((String)"remove", (PathAddress)opAddress);
        context.addStep(removeSubsystem, (OperationStepHandler)new OriginalSubsystemRemoveHandler(), OperationContext.Stage.MODEL, true);
        if (model.hasDefined("stack")) {
            List stacks = model.get("stack").asPropertyList();
            for (Property stack : stacks) {
                PathAddress address = opAddress.append("stack", stack.getName());
                ModelNode removeStack = Util.createOperation((String)"remove", (PathAddress)address);
                context.addStep(removeStack, (OperationStepHandler)StackRemoveHandler.INSTANCE, OperationContext.Stage.MODEL, true);
            }
        }
        context.stepCompleted();
    }

    static class OriginalSubsystemRemoveHandler
    extends AbstractRemoveStepHandler {
        OriginalSubsystemRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
            this.removeRuntimeServices(context, operation, model);
        }

        protected void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) {
            ServiceName protocolDefaultsService = ProtocolDefaultsService.SERVICE_NAME;
            context.removeService(protocolDefaultsService);
            ServiceName defaultChannelFactoryService = ChannelFactoryService.getServiceName(null);
            context.removeService(defaultChannelFactoryService);
        }
    }
}

