/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResource;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.Channel;

public class JGroupsSubsystemResource
implements Resource {
    private final Resource delegate;
    private volatile ServiceRegistry registry;

    public JGroupsSubsystemResource() {
        this(Resource.Factory.create());
    }

    public JGroupsSubsystemResource(Resource delegate) {
        this.delegate = delegate;
    }

    public ServiceRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ServiceRegistry registry) {
        this.registry = registry;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("channel".equals(element.getKey())) {
            return this.hasChannel(element);
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("channel".equals(element.getKey())) {
            if (this.hasChannel(element)) {
                String name = element.getValue();
                ServiceName serviceName = this.getServiceNameFromName(name);
                ServiceController serviceController = ServiceContainerHelper.getService((ServiceRegistry)this.registry, (ServiceName)serviceName);
                return new ChannelInstanceResource((ServiceController<Channel>)serviceController);
            }
            return null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("channel".equals(element.getKey())) {
            if (this.hasChannel(element)) {
                String name = element.getValue();
                ServiceName serviceName = this.getServiceNameFromName(name);
                ServiceController serviceController = ServiceContainerHelper.getService((ServiceRegistry)this.registry, (ServiceName)serviceName);
                return new ChannelInstanceResource((ServiceController<Channel>)serviceController);
            }
            throw new Resource.NoSuchResourceException(element);
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("channel".equals(childType)) {
            return this.getChildrenNames("channel").size() > 0;
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "channel".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            if (!this.hasChannel(address.getElement(0))) {
                throw new Resource.NoSuchResourceException(address.getElement(0));
            }
            String name = address.getElement(0).getValue();
            ServiceName serviceName = this.getServiceNameFromName(name);
            ServiceController serviceController = ServiceContainerHelper.getService((ServiceRegistry)this.registry, (ServiceName)serviceName);
            return new ChannelInstanceResource((ServiceController<Channel>)serviceController);
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>(this.delegate.getChildTypes());
        result.add("channel");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("channel".equals(childType)) {
            return this.getChannelNames();
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("channel".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (ServiceName serviceName : this.getChannelServiceNames()) {
                ServiceController serviceController = ServiceContainerHelper.getService((ServiceRegistry)this.registry, (ServiceName)serviceName);
                String name = this.getNameFromServiceName(serviceName);
                result.add(new ChannelInstanceResource.ChannelInstanceResourceEntry((ServiceController<Channel>)serviceController, "channel", name));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        String type = address.getKey();
        if (!"channel".equals(type)) {
            this.delegate.registerChild(address, resource);
        }
    }

    public Resource removeChild(PathElement address) {
        String type = address.getKey();
        if ("channel".equals(type)) {
            return null;
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    public boolean isProxy() {
        return this.delegate.isProxy();
    }

    public Resource clone() {
        JGroupsSubsystemResource clone = new JGroupsSubsystemResource(this.delegate.clone());
        clone.setRegistry(this.getRegistry());
        return clone;
    }

    private boolean hasChannel(PathElement element) {
        if (this.registry == null) {
            return false;
        }
        assert (element.getKey().equals("channel"));
        ServiceName channelName = ChannelInstanceResource.CHANNEL_PARENT.append(new String[]{element.getValue()});
        ServiceController controller = this.registry.getService(channelName);
        return controller != null && this.serviceIsUp(channelName);
    }

    private Set<ServiceName> getChannelServiceNames() {
        if (this.registry == null) {
            return Collections.emptySet();
        }
        HashSet<ServiceName> channelServiceNames = new HashSet<ServiceName>();
        assert (this.registry != null);
        List serviceNames = this.registry.getServiceNames();
        for (ServiceName serviceName : serviceNames) {
            if (!ChannelInstanceResource.CHANNEL_PARENT.isParentOf(serviceName) || !this.serviceIsUp(serviceName)) continue;
            channelServiceNames.add(serviceName);
        }
        return channelServiceNames;
    }

    private Set<String> getChannelNames() {
        HashSet<String> channelNames = new HashSet<String>();
        for (ServiceName serviceName : this.getChannelServiceNames()) {
            if (!this.serviceIsUp(serviceName)) continue;
            channelNames.add(this.getNameFromServiceName(serviceName));
        }
        return channelNames;
    }

    private String getNameFromServiceName(ServiceName serviceName) {
        String serviceNameAsString = serviceName.toString();
        return serviceNameAsString.substring(ChannelInstanceResource.CHANNEL_PREFIX_LENGTH + 1);
    }

    private ServiceName getServiceNameFromName(String name) {
        return ChannelInstanceResource.CHANNEL_PARENT.append(new String[]{name});
    }

    private boolean serviceIsUp(ServiceName name) {
        if (this.registry == null) {
            return false;
        }
        ServiceController controller = this.registry.getService(name);
        return controller != null ? ServiceController.State.UP.equals((Object)controller.getState()) : false;
    }
}

