/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JGroupsSubsystemXMLReader
implements XMLElementReader<List<ModelNode>> {
    private final JGroupsSchema schema;

    JGroupsSubsystemXMLReader(JGroupsSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> result) throws XMLStreamException {
        LinkedHashMap<PathAddress, ModelNode> operations = new LinkedHashMap<PathAddress, ModelNode>();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        String defaultStack = JGroupsSubsystemXMLReader.require(reader, Attribute.DEFAULT_STACK);
        JGroupsSubsystemResourceDefinition.DEFAULT_STACK.parseAndSetParameter(defaultStack, operation, (XMLStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STACK: {
                    this.parseStack(reader, address, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.addAll(operations.values());
    }

    private void parseStack(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, address, operations);
                    continue block5;
                }
                case PROTOCOL: {
                    this.parseProtocol(reader, address, operations);
                    continue block5;
                }
                case RELAY: {
                    if (!this.schema.since(JGroupsSchema.VERSION_2_0)) break;
                    this.parseRelay(reader, address, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = stackAddress.append(new PathElement[]{TransportResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    TransportResourceDefinition.TYPE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case SHARED: {
                    TransportResourceDefinition.SHARED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case SOCKET_BINDING: {
                    TransportResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case DEFAULT_EXECUTOR: {
                    TransportResourceDefinition.DEFAULT_EXECUTOR.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case OOB_EXECUTOR: {
                    TransportResourceDefinition.OOB_EXECUTOR.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case TIMER_EXECUTOR: {
                    TransportResourceDefinition.TIMER_EXECUTOR.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case THREAD_FACTORY: {
                    TransportResourceDefinition.THREAD_FACTORY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block16;
                }
                case SITE: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1)) {
                        TransportResourceDefinition.SITE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block16;
                    }
                }
                case RACK: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1)) {
                        TransportResourceDefinition.RACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block16;
                    }
                }
                case MACHINE: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1)) {
                        TransportResourceDefinition.MACHINE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block16;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!operation.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, address, operations);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProtocol(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String type = JGroupsSubsystemXMLReader.require(reader, Attribute.TYPE);
        PathAddress address = stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement(type)});
        ModelNode operation = Util.createOperation((String)"add-protocol", (PathAddress)stackAddress);
        operations.put(address, operation);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    ProtocolResourceDefinition.TYPE.parseAndSetParameter(type, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case SOCKET_BINDING: {
                    ProtocolResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, address, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        PathAddress address = parentAddress.append(new PathElement[]{PropertyResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        PropertyResourceDefinition.VALUE.parseAndSetParameter(reader.getElementText(), operation, (XMLStreamReader)reader);
    }

    private void parseRelay(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    RelayResourceDefinition.SITE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!operation.hasDefined("site")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.SITE));
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    this.parseRemoteSite(reader, address, operations);
                    continue block8;
                }
                case PROPERTY: {
                    this.parseProperty(reader, address, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteSite(XMLExtendedStreamReader reader, PathAddress relayAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String site = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        PathAddress address = relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.pathElement(site)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block5;
                }
                case STACK: {
                    RemoteSiteResourceDefinition.STACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case CLUSTER: {
                    RemoteSiteResourceDefinition.CLUSTER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static String require(XMLExtendedStreamReader reader, Attribute attribute) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getLocalName());
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
        }
        return value;
    }
}

