/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSchema;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackAddHandler;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JGroupsSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(JGroupsSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            JGroupsSubsystemResourceDefinition.DEFAULT_STACK.marshallAsAttribute(model, (XMLStreamWriter)writer);
            if (model.hasDefined(StackResourceDefinition.WILDCARD_PATH.getKey())) {
                for (Property property : model.get(StackResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    writer.writeStartElement(Element.STACK.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    ModelNode stack = property.getValue();
                    if (stack.get(TransportResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
                        ModelNode transport = stack.get(TransportResourceDefinition.PATH.getKeyValuePair());
                        writer.writeStartElement(Element.TRANSPORT.getLocalName());
                        TransportResourceDefinition.TYPE.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.SOCKET_BINDING.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.SHARED.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.DEFAULT_EXECUTOR.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.OOB_EXECUTOR.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.TIMER_EXECUTOR.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.THREAD_FACTORY.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.MACHINE.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.RACK.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        TransportResourceDefinition.SITE.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                        JGroupsSubsystemXMLWriter.writeProtocolProperties(writer, transport);
                        writer.writeEndElement();
                    }
                    if (stack.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property protocolProperty : StackAddHandler.getOrderedProtocolPropertyList(stack)) {
                            ModelNode protocol = protocolProperty.getValue();
                            writer.writeStartElement(Element.PROTOCOL.getLocalName());
                            ProtocolResourceDefinition.TYPE.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
                            ProtocolResourceDefinition.SOCKET_BINDING.marshallAsAttribute(protocol, (XMLStreamWriter)writer);
                            JGroupsSubsystemXMLWriter.writeProtocolProperties(writer, protocol);
                            writer.writeEndElement();
                        }
                    }
                    if (stack.get(RelayResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
                        ModelNode relay = stack.get(RelayResourceDefinition.PATH.getKeyValuePair());
                        JGroupsSubsystemXMLWriter.writeRelay(writer, relay);
                    }
                    writer.writeEndElement();
                }
            }
        }
        writer.writeEndElement();
    }

    private static void writeProtocolProperties(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        if (protocol.hasDefined("property")) {
            for (Property property : protocol.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private static void writeRelay(XMLExtendedStreamWriter writer, ModelNode relay) throws XMLStreamException {
        writer.writeStartElement(Element.RELAY.getLocalName());
        RelayResourceDefinition.SITE.marshallAsAttribute(relay, (XMLStreamWriter)writer);
        if (relay.hasDefined(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(Element.REMOTE_SITE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode remoteSite = property.getValue();
                RemoteSiteResourceDefinition.STACK.marshallAsAttribute(remoteSite, (XMLStreamWriter)writer);
                RemoteSiteResourceDefinition.CLUSTER.marshallAsAttribute(remoteSite, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }
}

