/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;

public class ProtocolDefaultsService
implements Service<ProtocolDefaults> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jgroups", "defaults"});
    private static final String DEFAULTS = "jgroups-defaults.xml";
    private final String resource;
    private volatile ProtocolDefaults defaults;

    public ProtocolDefaultsService() {
        this(DEFAULTS);
    }

    public ProtocolDefaultsService(String resource) {
        this.resource = resource;
    }

    public ProtocolDefaults getValue() {
        return this.defaults;
    }

    public void start(StartContext context) throws StartException {
        ProtocolStackConfigurator configurator = ProtocolDefaultsService.load(this.resource);
        Defaults defaults = new Defaults();
        for (ProtocolConfiguration config : configurator.getProtocolStack()) {
            defaults.add(config.getProtocolName(), config.getProperties());
        }
        this.defaults = defaults;
    }

    private static ProtocolStackConfigurator load(String resource) throws StartException {
        URL url = ProtocolDefaultsService.find(resource, JGroupsExtension.class.getClassLoader());
        JGroupsLogger.ROOT_LOGGER.debugf("Loading JGroups protocol defaults from %s", url.toString());
        try {
            return XmlConfigurator.getInstance((URL)url);
        }
        catch (IOException e) {
            throw new StartException(JGroupsLogger.ROOT_LOGGER.parserFailure(url));
        }
    }

    private static URL find(String resource, ClassLoader ... loaders) throws StartException {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new StartException(JGroupsLogger.ROOT_LOGGER.notFound(resource));
    }

    public void stop(StopContext context) {
        this.defaults = null;
    }

    static class Defaults
    implements ProtocolDefaults {
        private final Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();

        Defaults() {
        }

        void add(String protocol, Map<String, String> properties) {
            this.map.put(protocol, Collections.unmodifiableMap(properties));
        }

        @Override
        public Map<String, String> getProperties(String protocol) {
            Map<String, String> properties = this.map.get(protocol);
            return properties != null ? Collections.unmodifiableMap(properties) : Collections.emptyMap();
        }
    }
}

