/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResource;
import org.jboss.as.clustering.jgroups.subsystem.ChannelInstanceResourceDefinition;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jgroups.Channel;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.stack.Protocol;

public class ProtocolMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final boolean isField;

    public ProtocolMetricsHandler(boolean isField) {
        this.isField = isField;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String channelName = pathAddress.getElement(pathAddress.size() - 2).getValue();
        String protocolName = pathAddress.getElement(pathAddress.size() - 1).getValue();
        String attrName = operation.require("name").asString();
        ServiceName channelServiceName = ChannelInstanceResource.CHANNEL_PARENT.append(new String[]{channelName});
        ServiceController controller = context.getServiceRegistry(false).getService(channelServiceName);
        boolean started = controller != null && controller.getValue() != null;
        ModelNode result = new ModelNode();
        String className = "org.jgroups.protocols." + protocolName;
        Class<Protocol> protocolClass = null;
        boolean loaded = false;
        try {
            protocolClass = Protocol.class.getClassLoader().loadClass(className).asSubclass(Protocol.class);
            loaded = true;
        }
        catch (ClassNotFoundException e) {
            context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.unableToLoadProtocol(className));
        }
        if (loaded) {
            Field field = null;
            Method method = null;
            boolean found = false;
            try {
                if (this.isField) {
                    field = ProtocolMetricsHandler.getField(protocolClass, attrName);
                } else {
                    method = ProtocolMetricsHandler.getMethod(protocolClass, attrName);
                }
                found = true;
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.unknownMetric(attrName));
            }
            if (found && started) {
                Protocol protocol;
                Channel channel = (Channel)controller.getValue();
                int index = protocolName.lastIndexOf(46);
                if (index > 0) {
                    protocolName = protocolName.substring(index + 1);
                }
                if ((protocol = channel.getProtocolStack().findProtocol(protocolName)) == null) {
                    context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.protocolNotFoundInStack(protocolName));
                }
                Class<?> forType = this.isField ? field.getType() : method.getReturnType();
                FieldTypes type = ChannelInstanceResourceDefinition.isEquivalentModelTypeAvailable(forType) ? FieldTypes.getStat(forType.toString()) : FieldTypes.NON_PRIMITIVE;
                try {
                    result = this.isField ? ProtocolMetricsHandler.getProtocolFieldValue(protocol, field, type) : ProtocolMetricsHandler.getProtocolMethodValue(protocol, method, type);
                }
                catch (PrivilegedActionException pae) {
                    context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.privilegedAccessExceptionForAttribute(attrName));
                }
                catch (InstantiationException ie) {
                    context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.instantiationExceptionOnConverterForAttribute(attrName));
                }
                context.getResult().set(result);
            }
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    private static ModelNode getProtocolFieldValue(final Protocol p, final Field f, final FieldTypes t) throws PrivilegedActionException, InstantiationException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<ModelNode>(){

            @Override
            public ModelNode run() throws Exception {
                ModelNode result = new ModelNode();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                switch (t) {
                    case BOOLEAN: {
                        result.set(f.getBoolean(p));
                        break;
                    }
                    case BYTE: {
                        result.set((int)f.getByte(p));
                        break;
                    }
                    case CHAR: {
                        result.set((int)f.getChar(p));
                        break;
                    }
                    case SHORT: {
                        result.set((int)f.getShort(p));
                        break;
                    }
                    case INT: {
                        result.set(f.getInt(p));
                        break;
                    }
                    case LONG: {
                        result.set(f.getLong(p));
                        break;
                    }
                    case FLOAT: {
                        result.set((double)f.getFloat(p));
                        break;
                    }
                    case DOUBLE: {
                        result.set(f.getDouble(p));
                        break;
                    }
                    case STRING: {
                        String value = (String)f.get(p);
                        if (value == null) break;
                        result.set(value);
                        break;
                    }
                    case NON_PRIMITIVE: {
                        String value = ProtocolMetricsHandler.getStringValue(p, f);
                        if (value == null) break;
                        result.set(value);
                    }
                }
                return result;
            }
        });
    }

    private static ModelNode getProtocolMethodValue(final Protocol p, final Method m, final FieldTypes t) throws PrivilegedActionException, InstantiationException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<ModelNode>(){

            @Override
            public ModelNode run() throws Exception {
                ModelNode result = new ModelNode();
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                Object invocationResult = m.invoke((Object)p, new Object[0]);
                switch (t) {
                    case BOOLEAN: {
                        result.set(((Boolean)invocationResult).booleanValue());
                        break;
                    }
                    case BYTE: {
                        result.set((int)((Byte)invocationResult).byteValue());
                        break;
                    }
                    case CHAR: {
                        result.set((int)((Character)invocationResult).charValue());
                        break;
                    }
                    case SHORT: {
                        result.set((int)((Short)invocationResult).shortValue());
                        break;
                    }
                    case INT: {
                        result.set(((Integer)invocationResult).intValue());
                        break;
                    }
                    case LONG: {
                        result.set(((Long)invocationResult).longValue());
                        break;
                    }
                    case FLOAT: {
                        result.set(((Double)invocationResult).doubleValue());
                        break;
                    }
                    case DOUBLE: {
                        result.set(((Double)invocationResult).doubleValue());
                        break;
                    }
                    case STRING: {
                        String value = (String)invocationResult;
                        if (value == null) break;
                        result.set(value);
                        break;
                    }
                    case NON_PRIMITIVE: {
                        result.set(invocationResult.toString());
                    }
                }
                return result;
            }
        });
    }

    private static String getStringValue(Protocol protocol, Field field) throws IllegalAccessException, InstantiationException {
        Class converter;
        Object value;
        ManagedAttribute managed = field.getAnnotation(ManagedAttribute.class);
        Property property = field.getAnnotation(Property.class);
        assert (managed == null || property == null) : "Attribute " + field.getName() + " is both property and managed attribute";
        if (managed != null && (value = field.get(protocol)) != null) {
            return value.toString();
        }
        if (property != null && (converter = property.converter()) != null) {
            PropertyConverter instance = (PropertyConverter)converter.newInstance();
            Object value2 = field.get(protocol);
            if (value2 != null) {
                return instance.toString(value2);
            }
        }
        return null;
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ProtocolMetricsHandler.getField(superClass, fieldName);
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ProtocolMetricsHandler.getMethod(superClass, methodName);
        }
    }

    public static enum FieldTypes {
        BOOLEAN("boolean"),
        BYTE("byte"),
        CHAR("char"),
        SHORT("short"),
        INT("int"),
        LONG("long"),
        FLOAT("float"),
        DOUBLE("double"),
        STRING("class java.lang.String"),
        NON_PRIMITIVE("non_primitive");

        private static final Map<String, FieldTypes> MAP;
        final String name;

        private FieldTypes(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static FieldTypes getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, FieldTypes>();
            for (FieldTypes type : FieldTypes.values()) {
                MAP.put(type.toString(), type);
            }
        }
    }
}

