/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.RelayConfiguration;
import org.jboss.as.clustering.jgroups.RemoteSiteConfiguration;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.threads.JBossExecutors;

public class StackAddHandler
extends AbstractAddStepHandler {
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource);
        if (operation.hasDefined("transport")) {
            ModelNode addTransport = operation.get("transport").clone();
            addTransport.get("operation-name").set("add");
            ModelNode transportAddress = operation.get("address").clone();
            transportAddress.add("transport", "TRANSPORT");
            transportAddress.protect();
            addTransport.get("address").set(transportAddress);
            context.addStep(addTransport, TransportResourceDefinition.ADD_HANDLER, OperationContext.Stage.MODEL, true);
        }
        if (operation.hasDefined("protocols")) {
            List protocols = operation.get("protocols").asList();
            ListIterator iterator = protocols.listIterator(protocols.size());
            while (iterator.hasPrevious()) {
                ModelNode protocol = (ModelNode)iterator.previous();
                ModelNode addProtocol = protocol.clone();
                addProtocol.get("operation-name").set("add-protocol");
                ModelNode protocolAddress = operation.get("address").clone();
                protocolAddress.protect();
                addProtocol.get("address").set(protocolAddress);
                context.addStep(addProtocol, ProtocolResourceDefinition.ADD_HANDLER, OperationContext.Stage.MODEL, true);
            }
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        StackAddHandler.installRuntimeServices(context, operation, model, verificationHandler, newControllers);
    }

    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        StackAddHandler.protocolStackSanityCheck(name, model);
        List<Property> orderedProtocols = StackAddHandler.getOrderedProtocolPropertyList(model);
        ModelNode transport = model.get(new String[]{"transport", "TRANSPORT"});
        ModelNode resolvedValue = null;
        resolvedValue = TransportResourceDefinition.TYPE.resolveModelAttribute(context, transport);
        String type = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        boolean shared = TransportResourceDefinition.SHARED.resolveModelAttribute(context, transport).asBoolean();
        resolvedValue = TransportResourceDefinition.MACHINE.resolveModelAttribute(context, transport);
        String machine = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.RACK.resolveModelAttribute(context, transport);
        String rack = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.SITE.resolveModelAttribute(context, transport);
        String site = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.TIMER_EXECUTOR.resolveModelAttribute(context, transport);
        String timerExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.THREAD_FACTORY.resolveModelAttribute(context, transport);
        String threadFactory = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING.resolveModelAttribute(context, transport);
        String diagnosticsSocketBinding = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.DEFAULT_EXECUTOR.resolveModelAttribute(context, transport);
        String defaultExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.OOB_EXECUTOR.resolveModelAttribute(context, transport);
        String oobExecutor = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        resolvedValue = TransportResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, transport);
        String transportSocketBinding = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        Transport transportConfig = new Transport(type);
        transportConfig.setShared(shared);
        transportConfig.setTopology(site, rack, machine);
        StackAddHandler.initProtocolProperties(context, transport, transportConfig);
        Relay relayConfig = null;
        LinkedList<Map.Entry<String, Injector<ChannelFactory>>> stacks = new LinkedList<Map.Entry<String, Injector<ChannelFactory>>>();
        if (model.hasDefined("relay")) {
            ModelNode relay = model.get(new String[]{"relay", "RELAY"});
            String siteName = RelayResourceDefinition.SITE.resolveModelAttribute(context, relay).asString();
            relayConfig = new Relay(siteName);
            StackAddHandler.initProtocolProperties(context, relay, relayConfig);
            if (relay.hasDefined("remote-site")) {
                List<RemoteSiteConfiguration> remoteSites = relayConfig.getRemoteSites();
                for (Property remoteSiteProperty : relay.get("remote-site").asPropertyList()) {
                    String remoteSiteName = remoteSiteProperty.getName();
                    ModelNode remoteSite = remoteSiteProperty.getValue();
                    String cluster = RemoteSiteResourceDefinition.CLUSTER.resolveModelAttribute(context, remoteSite).asString();
                    String stack = RemoteSiteResourceDefinition.STACK.resolveModelAttribute(context, remoteSite).asString();
                    InjectedValue channelFactory = new InjectedValue();
                    remoteSites.add(new RemoteSite(remoteSiteName, cluster, (Value<ChannelFactory>)channelFactory));
                    stacks.add(new AbstractMap.SimpleImmutableEntry<String, InjectedValue>(stack, channelFactory));
                }
            }
        }
        ProtocolStack stackConfig = new ProtocolStack(name, transportConfig, relayConfig);
        ArrayList<Map.Entry<Protocol, String>> protocolSocketBindings = new ArrayList<Map.Entry<Protocol, String>>(orderedProtocols.size());
        for (Property protocolProperty : orderedProtocols) {
            ModelNode protocol = protocolProperty.getValue();
            resolvedValue = ProtocolResourceDefinition.TYPE.resolveModelAttribute(context, protocol);
            String protocolType = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            Protocol protocolConfig = new Protocol(protocolType);
            StackAddHandler.initProtocolProperties(context, protocol, protocolConfig);
            stackConfig.getProtocols().add(protocolConfig);
            resolvedValue = ProtocolResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, protocol);
            String protocolSocketBinding = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            protocolSocketBindings.add(new AbstractMap.SimpleImmutableEntry<Protocol, String>(protocolConfig, protocolSocketBinding));
        }
        ServiceController<ChannelFactory> cfsController = StackAddHandler.installChannelFactoryService(context.getServiceTarget(), name, diagnosticsSocketBinding, defaultExecutor, oobExecutor, timerExecutor, threadFactory, transportSocketBinding, protocolSocketBindings, transportConfig, stackConfig, stacks, verificationHandler);
        if (newControllers != null) {
            newControllers.add(cfsController);
        }
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        context.removeService(ChannelFactoryService.getServiceName(name));
    }

    private static ServiceController<ChannelFactory> installChannelFactoryService(ServiceTarget target, String name, String diagnosticsSocketBinding, String defaultExecutor, String oobExecutor, String timerExecutor, String threadFactory, String transportSocketBinding, List<Map.Entry<Protocol, String>> protocolSocketBindings, Transport transportConfig, ProtocolStack stackConfig, List<Map.Entry<String, Injector<ChannelFactory>>> stacks, ServiceVerificationHandler verificationHandler) {
        ServiceBuilder builder = target.addService(ChannelFactoryService.getServiceName(name), (Service)new ChannelFactoryService(stackConfig)).addDependency(ProtocolDefaultsService.SERVICE_NAME, ProtocolDefaults.class, stackConfig.getDefaultsInjector()).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, stackConfig.getEnvironmentInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        StackAddHandler.addSocketBindingDependency((ServiceBuilder<ChannelFactory>)builder, transportSocketBinding, transportConfig.getSocketBindingInjector());
        for (Map.Entry<Protocol, String> entry : protocolSocketBindings) {
            StackAddHandler.addSocketBindingDependency((ServiceBuilder<ChannelFactory>)builder, entry.getValue(), entry.getKey().getSocketBindingInjector());
        }
        StackAddHandler.addSocketBindingDependency((ServiceBuilder<ChannelFactory>)builder, diagnosticsSocketBinding, transportConfig.getDiagnosticsSocketBindingInjector());
        StackAddHandler.addExecutorDependency((ServiceBuilder<ChannelFactory>)builder, defaultExecutor, transportConfig.getDefaultExecutorInjector());
        StackAddHandler.addExecutorDependency((ServiceBuilder<ChannelFactory>)builder, oobExecutor, transportConfig.getOOBExecutorInjector());
        if (timerExecutor != null) {
            builder.addDependency(ThreadsServices.executorName((String)timerExecutor), ScheduledExecutorService.class, transportConfig.getTimerExecutorInjector());
        }
        if (threadFactory != null) {
            builder.addDependency(ThreadsServices.threadFactoryName((String)threadFactory), ThreadFactory.class, transportConfig.getThreadFactoryInjector());
        }
        for (Map.Entry<Object, String> entry : stacks) {
            builder.addDependency(ChannelFactoryService.getServiceName((String)entry.getKey()), ChannelFactory.class, (Injector)entry.getValue());
        }
        return builder.install();
    }

    private static void initProtocolProperties(OperationContext context, ModelNode protocol, Protocol protocolConfig) throws OperationFailedException {
        Map<String, String> properties = protocolConfig.getProperties();
        if (protocol.hasDefined("property")) {
            for (Property property : protocol.get("property").asPropertyList()) {
                String propertyName = property.getName();
                ModelNode propertyValue = null;
                propertyValue = PropertyResourceDefinition.VALUE.resolveModelAttribute(context, property.getValue());
                properties.put(propertyName, propertyValue.asString());
            }
        }
    }

    public static List<Property> getOrderedProtocolPropertyList(ModelNode stack) {
        ModelNode orderedProtocols = new ModelNode();
        if (!stack.hasDefined("protocols")) {
            return null;
        }
        List protocolOrdering = stack.get("protocols").clone().asList();
        ModelNode unorderedProtocols = stack.get("protocol");
        for (ModelNode protocolName : protocolOrdering) {
            ModelNode protocolModel = unorderedProtocols.get(protocolName.asString());
            orderedProtocols.add(protocolName.asString(), protocolModel);
        }
        return orderedProtocols.asPropertyList();
    }

    private static void addSocketBindingDependency(ServiceBuilder<ChannelFactory> builder, String socketBinding, Injector<SocketBinding> injector) {
        if (socketBinding != null) {
            builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding}), SocketBinding.class, injector);
        }
    }

    private static void addExecutorDependency(ServiceBuilder<ChannelFactory> builder, String executor, Injector<Executor> injector) {
        if (executor != null) {
            builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, injector);
        }
    }

    private static void protocolStackSanityCheck(String stackName, ModelNode model) throws OperationFailedException {
        ModelNode transport = model.get(new String[]{"transport", "TRANSPORT"});
        if (!transport.isDefined()) {
            throw JGroupsLogger.ROOT_LOGGER.transportNotDefined(stackName);
        }
        List<Property> protocols = StackAddHandler.getOrderedProtocolPropertyList(model);
        if (protocols == null || protocols.size() <= 0) {
            throw JGroupsLogger.ROOT_LOGGER.protocolListNotDefined(stackName);
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    static class Protocol
    implements ProtocolConfiguration {
        private final String name;
        private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
        private final Map<String, String> properties = new HashMap<String, String>();
        final Class<?> protocolClass;

        Protocol(final String name) {
            this.name = name;
            PrivilegedAction action = new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return Protocol.this.getClass().getClassLoader().loadClass("org.jgroups.protocols." + name);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException(e);
                    }
                }
            };
            this.protocolClass = (Class)AccessController.doPrivileged(action);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasProperty(final String property) {
            PrivilegedAction<Field> action = new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    return Protocol.getField(Protocol.this.protocolClass, property);
                }
            };
            return AccessController.doPrivileged(action) != null;
        }

        static Field getField(Class<?> targetClass, String property) {
            try {
                return targetClass.getDeclaredField(property);
            }
            catch (NoSuchFieldException e) {
                Class<?> superClass = targetClass.getSuperclass();
                return superClass != null && org.jgroups.stack.Protocol.class.isAssignableFrom(superClass) ? Protocol.getField(superClass, property) : null;
            }
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties;
        }

        Injector<SocketBinding> getSocketBindingInjector() {
            return this.socketBinding;
        }

        @Override
        public SocketBinding getSocketBinding() {
            return (SocketBinding)this.socketBinding.getOptionalValue();
        }
    }

    static class RemoteSite
    implements RemoteSiteConfiguration {
        private final Value<ChannelFactory> channelFactory;
        private final String name;
        private final String clusterName;

        RemoteSite(String name, String clusterName, Value<ChannelFactory> channelFactory) {
            this.name = name;
            this.clusterName = clusterName;
            this.channelFactory = channelFactory;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ChannelFactory getChannelFactory() {
            return (ChannelFactory)this.channelFactory.getValue();
        }

        @Override
        public String getClusterName() {
            return this.clusterName;
        }
    }

    static class Relay
    extends Protocol
    implements RelayConfiguration {
        private final List<RemoteSiteConfiguration> remoteSites = new LinkedList<RemoteSiteConfiguration>();
        private final String siteName;

        Relay(String siteName) {
            super("relay.RELAY2");
            this.siteName = siteName;
        }

        @Override
        public String getSiteName() {
            return this.siteName;
        }

        @Override
        public List<RemoteSiteConfiguration> getRemoteSites() {
            return this.remoteSites;
        }
    }

    static class Transport
    extends Protocol
    implements TransportConfiguration {
        private final InjectedValue<SocketBinding> diagnosticsSocketBinding = new InjectedValue();
        private final InjectedValue<Executor> defaultExecutor = new InjectedValue();
        private final InjectedValue<Executor> oobExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> timerExecutor = new InjectedValue();
        private final InjectedValue<ThreadFactory> threadFactory = new InjectedValue();
        private boolean shared = true;
        private TransportConfiguration.Topology topology;

        Transport(String name) {
            super(name);
        }

        Injector<SocketBinding> getDiagnosticsSocketBindingInjector() {
            return this.diagnosticsSocketBinding;
        }

        Injector<Executor> getDefaultExecutorInjector() {
            return this.defaultExecutor;
        }

        Injector<Executor> getOOBExecutorInjector() {
            return this.oobExecutor;
        }

        Injector<ScheduledExecutorService> getTimerExecutorInjector() {
            return this.timerExecutor;
        }

        Injector<ThreadFactory> getThreadFactoryInjector() {
            return this.threadFactory;
        }

        void setShared(boolean shared) {
            this.shared = shared;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        @Override
        public TransportConfiguration.Topology getTopology() {
            return this.topology;
        }

        public void setTopology(String site, String rack, String machine) {
            if (site != null || rack != null || machine != null) {
                this.topology = new TopologyImpl(site, rack, machine);
            }
        }

        @Override
        public SocketBinding getDiagnosticsSocketBinding() {
            return (SocketBinding)this.diagnosticsSocketBinding.getOptionalValue();
        }

        @Override
        public ExecutorService getDefaultExecutor() {
            Executor executor = (Executor)this.defaultExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ExecutorService getOOBExecutor() {
            Executor executor = (Executor)this.oobExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ScheduledExecutorService getTimerExecutor() {
            return (ScheduledExecutorService)this.timerExecutor.getOptionalValue();
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return (ThreadFactory)this.threadFactory.getOptionalValue();
        }

        private class TopologyImpl
        implements TransportConfiguration.Topology {
            private final String site;
            private final String rack;
            private final String machine;

            TopologyImpl(String site, String rack, String machine) {
                this.site = site;
                this.rack = rack;
                this.machine = machine;
            }

            @Override
            public String getMachine() {
                return this.machine;
            }

            @Override
            public String getRack() {
                return this.rack;
            }

            @Override
            public String getSite() {
                return this.site;
            }
        }
    }

    static class ProtocolStack
    implements ProtocolStackConfiguration {
        private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
        private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
        private final String name;
        private final TransportConfiguration transport;
        private final RelayConfiguration relay;
        private final List<ProtocolConfiguration> protocols = new LinkedList<ProtocolConfiguration>();

        ProtocolStack(String name, TransportConfiguration transport, RelayConfiguration relay) {
            this.name = name;
            this.transport = transport;
            this.relay = relay;
        }

        Injector<ProtocolDefaults> getDefaultsInjector() {
            return this.defaults;
        }

        Injector<ServerEnvironment> getEnvironmentInjector() {
            return this.environment;
        }

        @Override
        public TransportConfiguration getTransport() {
            return this.transport;
        }

        @Override
        public List<ProtocolConfiguration> getProtocols() {
            return this.protocols;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ProtocolDefaults getDefaults() {
            return (ProtocolDefaults)this.defaults.getValue();
        }

        @Override
        public ServerEnvironment getEnvironment() {
            return (ServerEnvironment)this.environment.getValue();
        }

        @Override
        public RelayConfiguration getRelay() {
            return this.relay;
        }
    }
}

