/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class TransportAddHandler
implements OperationStepHandler {
    private final AttributeDefinition[] attributes;

    public TransportAddHandler(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        for (AttributeDefinition attribute : this.attributes) {
            if (attribute.getName().equals("properties")) continue;
            attribute.validateAndSet(operation, subModel);
        }
        if (operation.hasDefined("properties")) {
            for (Property property : operation.get("properties").asPropertyList()) {
                Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                ModelNode value = property.getValue();
                if (!value.isDefined()) {
                    throw JGroupsLogger.ROOT_LOGGER.propertyNotDefined(property.getName(), TransportResourceDefinition.PATH.toString());
                }
                PropertyResourceDefinition.VALUE.validateAndSet(value, param.getModel());
            }
        }
        this.reloadRequiredStep(context);
        context.stepCompleted();
    }

    void reloadRequiredStep(OperationContext context) {
        if (context.getProcessType().isServer() && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

