/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.Serializable;
import java.util.Vector;
import org.omg.CORBA.INTERNAL;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class Name
implements Serializable {
    private NameComponent[] fullName;
    private NameComponent baseName;
    private NameComponent[] ctxName;

    public Name() {
        this.fullName = null;
        this.baseName = null;
        this.ctxName = null;
    }

    public Name(NameComponent[] n) throws InvalidName {
        if (n == null || n.length == 0) {
            throw new InvalidName();
        }
        this.fullName = n;
        this.baseName = n[n.length - 1];
        if (n.length > 1) {
            this.ctxName = new NameComponent[n.length - 1];
            for (int i = 0; i < n.length - 1; ++i) {
                this.ctxName[i] = n[i];
            }
        } else {
            this.ctxName = null;
        }
    }

    public Name(String string_name) throws InvalidName {
        this(Name.toName(string_name));
    }

    public Name(NameComponent n) throws InvalidName {
        if (n == null) {
            throw new InvalidName();
        }
        this.baseName = n;
        this.fullName = new NameComponent[1];
        this.fullName[0] = n;
        this.ctxName = null;
    }

    public NameComponent baseNameComponent() {
        return this.baseName;
    }

    public String kind() {
        return this.baseName.kind;
    }

    public NameComponent[] components() {
        return this.fullName;
    }

    public Name ctxName() {
        if (this.ctxName != null) {
            try {
                return new Name(this.ctxName);
            }
            catch (InvalidName e) {
                throw new INTERNAL(e.toString());
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Name)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public Name fullName() throws InvalidName {
        return new Name(this.fullName);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        try {
            return Name.toString(this.fullName);
        }
        catch (InvalidName in) {
            return "<invalid>";
        }
    }

    private static NameComponent getComponent(String sn) throws InvalidName {
        int len = sn.length();
        boolean inKind = false;
        StringBuffer id = new StringBuffer();
        StringBuffer kind = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = sn.charAt(i);
            if (ch == '\\') {
                if (++i >= len) {
                    throw new InvalidName();
                }
                ch = sn.charAt(i);
            } else if (ch == '.') {
                if (inKind) {
                    throw new InvalidName();
                }
                inKind = true;
                continue;
            }
            if (inKind) {
                kind.append(ch);
                continue;
            }
            id.append(ch);
        }
        return new NameComponent(id.toString(), kind.toString());
    }

    public static NameComponent[] toName(String sn) throws InvalidName {
        int i;
        if (sn == null || sn.length() == 0 || sn.startsWith("/")) {
            throw new InvalidName();
        }
        Vector<NameComponent> v = new Vector<NameComponent>();
        int start = 0;
        for (i = 0; i < sn.length(); ++i) {
            if (sn.charAt(i) != '/' || sn.charAt(i - 1) == '\\') continue;
            if (i - start == 0) {
                throw new InvalidName();
            }
            v.addElement(Name.getComponent(sn.substring(start, i)));
            start = i + 1;
        }
        if (start < i) {
            v.addElement(Name.getComponent(sn.substring(start, i)));
        }
        NameComponent[] result = new NameComponent[v.size()];
        for (int j = 0; j < result.length; ++j) {
            result[j] = (NameComponent)v.elementAt(j);
        }
        return result;
    }

    public static String toString(NameComponent[] n) throws InvalidName {
        if (n == null || n.length == 0) {
            throw new InvalidName();
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < n.length; ++i) {
            if (i > 0) {
                b.append("/");
            }
            if (n[i].id.length() > 0) {
                b.append(Name.escape(n[i].id));
            }
            if (n[i].kind.length() > 0 || n[i].id.length() == 0) {
                b.append(".");
            }
            if (n[i].kind.length() <= 0) continue;
            b.append(Name.escape(n[i].kind));
        }
        return b.toString();
    }

    private static String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '/' && sb.charAt(i) != '\\' && sb.charAt(i) != '.') continue;
            sb.insert(i, '\\');
            ++i;
        }
        return sb.toString();
    }
}

